/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.eventhubs;

import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.eventhubs.EventHubsConfiguration;
import org.apache.camel.component.azure.eventhubs.EventHubsEndpoint;
import org.apache.camel.component.azure.eventhubs.client.EventHubsClientFactory;
import org.apache.camel.component.azure.eventhubs.operations.EventHubsProducerOperations;
import org.apache.camel.support.DefaultAsyncProducer;

public class EventHubsProducer
extends DefaultAsyncProducer {
    private EventHubProducerAsyncClient producerAsyncClient;
    private EventHubsProducerOperations producerOperations;

    public EventHubsProducer(Endpoint endpoint) {
        super(endpoint);
    }

    protected void doStart() throws Exception {
        super.doStart();
        EventHubsConfiguration configuration = this.getConfiguration();
        this.producerAsyncClient = configuration.getProducerAsyncClient();
        if (this.producerAsyncClient == null) {
            this.producerAsyncClient = EventHubsClientFactory.createEventHubProducerAsyncClient(configuration);
        }
        this.producerOperations = new EventHubsProducerOperations(this.producerAsyncClient, this.getConfiguration());
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            return this.producerOperations.sendEvents(exchange, callback);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }

    protected void doStop() throws Exception {
        if (this.producerAsyncClient != null) {
            this.producerAsyncClient.close();
            this.producerAsyncClient = null;
        }
        super.doStop();
    }

    public EventHubsEndpoint getEndpoint() {
        return (EventHubsEndpoint)super.getEndpoint();
    }

    public EventHubsConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }
}

