/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.eventhubs;

import com.azure.identity.DefaultAzureCredential;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.azure.eventhubs.CredentialType;
import org.apache.camel.component.azure.eventhubs.EventHubsConfiguration;
import org.apache.camel.component.azure.eventhubs.EventHubsEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="azure-eventhubs")
public class EventHubsComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(EventHubsComponent.class);
    @Metadata
    private EventHubsConfiguration configuration = new EventHubsConfiguration();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        EventHubsConfiguration configuration = this.configuration.copy();
        EventHubsEndpoint endpoint = new EventHubsEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (this.isTokenCredentialSet(configuration) || !this.isProducerAsyncClientSet(configuration) && !this.isConnectionStringSet(configuration)) {
            this.checkAndSetNamespaceAndHubName(configuration, remaining);
        }
        if (endpoint.getConfiguration().getTokenCredential() == null) {
            if (endpoint.getConfiguration().getCredentialType() == null) {
                endpoint.getConfiguration().setCredentialType(CredentialType.CONNECTION_STRING);
            }
        } else {
            boolean azure = endpoint.getConfiguration().getTokenCredential() instanceof DefaultAzureCredential;
            endpoint.getConfiguration().setCredentialType(azure ? CredentialType.AZURE_IDENTITY : CredentialType.TOKEN_CREDENTIAL);
        }
        this.validateConfigurations(configuration);
        return endpoint;
    }

    public EventHubsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EventHubsConfiguration configuration) {
        this.configuration = configuration;
    }

    private void validateConfigurations(EventHubsConfiguration configuration) {
        if (!(this.isAccessKeyAndAccessNameSet(configuration) || this.isProducerAsyncClientSet(configuration) || this.isConnectionStringSet(configuration) || this.isTokenCredentialSet(configuration) || this.isAzureIdentitySet(configuration))) {
            throw new IllegalArgumentException("Azure EventHubs SharedAccessName/SharedAccessKey, ProducerAsyncClient, ConnectionString or TokenCredential must be specified.");
        }
    }

    private boolean isAccessKeyAndAccessNameSet(EventHubsConfiguration configuration) {
        return ObjectHelper.isNotEmpty((String)configuration.getSharedAccessName()) && ObjectHelper.isNotEmpty((String)configuration.getSharedAccessKey());
    }

    private boolean isConnectionStringSet(EventHubsConfiguration configuration) {
        return ObjectHelper.isNotEmpty((String)configuration.getConnectionString());
    }

    private boolean isTokenCredentialSet(EventHubsConfiguration configuration) {
        return ObjectHelper.isNotEmpty((Object)configuration.getTokenCredential());
    }

    private boolean isProducerAsyncClientSet(EventHubsConfiguration configuration) {
        return ObjectHelper.isNotEmpty((Object)configuration.getProducerAsyncClient());
    }

    private boolean isAzureIdentitySet(EventHubsConfiguration configuration) {
        return ObjectHelper.isNotEmpty((Object)((Object)configuration.getCredentialType())) && configuration.getCredentialType().equals((Object)CredentialType.AZURE_IDENTITY);
    }

    private void checkAndSetNamespaceAndHubName(EventHubsConfiguration configuration, String remaining) {
        String errorMessage = "ConnectionString, ProducerAsyncClient or Namespace and EventHub name must be set";
        if (ObjectHelper.isEmpty((String)remaining)) {
            throw new IllegalArgumentException("ConnectionString, ProducerAsyncClient or Namespace and EventHub name must be set");
        }
        String[] parts = remaining.split("/");
        if (parts.length != 2) {
            throw new IllegalArgumentException("ConnectionString, ProducerAsyncClient or Namespace and EventHub name must be set");
        }
        configuration.setNamespace(parts[0]);
        configuration.setEventHubName(parts[1]);
    }
}

