/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.cosmosdb;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class CosmosDbEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":databaseName/containerName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "azure-cosmosdb".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "databaseName", null, false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "containerName", null, false, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(33);
        props.add("accountKey");
        props.add("bridgeErrorHandler");
        props.add("changeFeedProcessorOptions");
        props.add("clientTelemetryEnabled");
        props.add("connectionSharingAcrossClientsEnabled");
        props.add("consistencyLevel");
        props.add("containerName");
        props.add("containerPartitionKeyPath");
        props.add("contentResponseOnWriteEnabled");
        props.add("cosmosAsyncClient");
        props.add("createContainerIfNotExists");
        props.add("createDatabaseIfNotExists");
        props.add("createLeaseContainerIfNotExists");
        props.add("createLeaseDatabaseIfNotExists");
        props.add("credentialType");
        props.add("databaseEndpoint");
        props.add("databaseName");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("hostName");
        props.add("indexingPolicy");
        props.add("itemId");
        props.add("itemPartitionKey");
        props.add("lazyStartProducer");
        props.add("leaseContainerName");
        props.add("leaseDatabaseName");
        props.add("multipleWriteRegionsEnabled");
        props.add("operation");
        props.add("preferredRegions");
        props.add("query");
        props.add("queryRequestOptions");
        props.add("readRequestsFallbackEnabled");
        props.add("throughputProperties");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(1);
        secretProps.add("accountKey");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

