/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.transcribe.client.impl;

import java.net.URI;
import org.apache.camel.component.aws2.transcribe.Transcribe2Configuration;
import org.apache.camel.component.aws2.transcribe.client.Transcribe2InternalClient;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.transcribe.TranscribeClient;
import software.amazon.awssdk.services.transcribe.TranscribeClientBuilder;
import software.amazon.awssdk.utils.AttributeMap;

public class Transcribe2ClientSessionTokenImpl
implements Transcribe2InternalClient {
    private static final Logger LOG = LoggerFactory.getLogger(Transcribe2ClientSessionTokenImpl.class);
    private Transcribe2Configuration configuration;

    public Transcribe2ClientSessionTokenImpl(Transcribe2Configuration configuration) {
        this.configuration = configuration;
    }

    public Transcribe2ClientSessionTokenImpl(SdkHttpClient httpClient, Transcribe2Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public TranscribeClient getTranscribeClient() {
        TranscribeClient client = null;
        TranscribeClientBuilder clientBuilder = TranscribeClient.builder();
        ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder();
        if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
            clientBuilder = (TranscribeClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        if (this.configuration.isOverrideEndpoint()) {
            clientBuilder.endpointOverride(URI.create(this.configuration.getUriEndpointOverride()));
        }
        if (ObjectHelper.isNotEmpty((String)this.configuration.getAccessKey()) && ObjectHelper.isNotEmpty((String)this.configuration.getSecretKey()) && ObjectHelper.isNotEmpty((String)this.configuration.getSessionToken())) {
            AwsSessionCredentials cred = AwsSessionCredentials.create((String)this.configuration.getAccessKey(), (String)this.configuration.getSecretKey(), (String)this.configuration.getSessionToken());
            clientBuilder = (TranscribeClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
        }
        if (this.configuration.isTrustAllCertificates()) {
            httpClientBuilder.buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)Boolean.TRUE).build());
        }
        clientBuilder.httpClient(httpClientBuilder.build());
        client = (TranscribeClient)clientBuilder.build();
        return client;
    }
}

