/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.transcribe;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.transcribe.Transcribe2ClientFactory;
import org.apache.camel.component.aws2.transcribe.Transcribe2Configuration;
import org.apache.camel.component.aws2.transcribe.Transcribe2Constants;
import org.apache.camel.component.aws2.transcribe.Transcribe2Producer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.transcribe.TranscribeClient;

@UriEndpoint(firstVersion="4.15.0", scheme="aws2-transcribe", title="AWS Transcribe", syntax="aws2-transcribe:label", category={Category.CLOUD, Category.MESSAGING}, producerOnly=true, headersClass=Transcribe2Constants.class)
public class Transcribe2Endpoint
extends DefaultEndpoint {
    private TranscribeClient transcribeClient;
    @UriParam
    private Transcribe2Configuration configuration;

    public Transcribe2Endpoint(String uri, Component component, Transcribe2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new Transcribe2Producer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.transcribeClient = this.configuration.getTranscribeClient() != null ? this.configuration.getTranscribeClient() : Transcribe2ClientFactory.getTranscribeClient(this.configuration);
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getTranscribeClient()) && this.transcribeClient != null) {
            this.transcribeClient.close();
        }
        super.doStop();
    }

    public Transcribe2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Transcribe2Configuration configuration) {
        this.configuration = configuration;
    }

    public TranscribeClient getTranscribeClient() {
        return this.transcribeClient;
    }

    public void setTranscribeClient(TranscribeClient transcribeClient) {
        this.transcribeClient = transcribeClient;
    }
}

