/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.transcribe;

import java.net.URI;
import org.apache.camel.component.aws2.transcribe.Transcribe2Configuration;
import org.apache.camel.component.aws2.transcribe.client.Transcribe2InternalClient;
import org.apache.camel.component.aws2.transcribe.client.impl.Transcribe2ClientIAMOptimizedImpl;
import org.apache.camel.component.aws2.transcribe.client.impl.Transcribe2ClientIAMProfileOptimizedImpl;
import org.apache.camel.component.aws2.transcribe.client.impl.Transcribe2ClientSessionTokenImpl;
import org.apache.camel.component.aws2.transcribe.client.impl.Transcribe2ClientStandardImpl;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.services.transcribe.TranscribeClient;

public final class Transcribe2ClientFactory {
    private Transcribe2ClientFactory() {
    }

    public static TranscribeClient getTranscribeClient(Transcribe2Configuration configuration) {
        TranscribeClient client = null;
        Transcribe2InternalClient transcribeInternalClient = null;
        if (ObjectHelper.isNotEmpty((String)configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)configuration.getProxyPort())) {
            ProxyConfiguration.Builder proxyConfig = ProxyConfiguration.builder();
            proxyConfig = proxyConfig.endpoint(URI.create(configuration.getProxyProtocol() + "://" + configuration.getProxyHost() + ":" + configuration.getProxyPort()));
            if (ObjectHelper.isNotEmpty((String)configuration.getProxyUsername()) && ObjectHelper.isNotEmpty((String)configuration.getProxyPassword())) {
                proxyConfig.username(configuration.getProxyUsername());
                proxyConfig.password(configuration.getProxyPassword());
            }
            ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            transcribeInternalClient = configuration.isUseDefaultCredentialsProvider() ? new Transcribe2ClientIAMOptimizedImpl(httpClientBuilder.build(), configuration) : (configuration.isUseProfileCredentialsProvider() ? new Transcribe2ClientIAMProfileOptimizedImpl(httpClientBuilder.build(), configuration) : (configuration.isUseSessionCredentials() ? new Transcribe2ClientSessionTokenImpl(httpClientBuilder.build(), configuration) : new Transcribe2ClientStandardImpl(httpClientBuilder.build(), configuration)));
        } else {
            transcribeInternalClient = configuration.isUseDefaultCredentialsProvider() ? new Transcribe2ClientIAMOptimizedImpl(configuration) : (configuration.isUseProfileCredentialsProvider() ? new Transcribe2ClientIAMProfileOptimizedImpl(configuration) : (configuration.isUseSessionCredentials() ? new Transcribe2ClientSessionTokenImpl(configuration) : new Transcribe2ClientStandardImpl(configuration)));
        }
        client = transcribeInternalClient.getTranscribeClient();
        return client;
    }
}

