/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.textract.client;

import org.apache.camel.component.aws2.textract.Textract2Configuration;
import org.apache.camel.component.aws2.textract.client.Textract2InternalClient;
import org.apache.camel.component.aws2.textract.client.impl.Textract2ClientIAMOptimized;
import org.apache.camel.component.aws2.textract.client.impl.Textract2ClientIAMProfileOptimized;
import org.apache.camel.component.aws2.textract.client.impl.Textract2ClientSessionTokenImpl;
import org.apache.camel.component.aws2.textract.client.impl.Textract2ClientStandardImpl;

public final class Textract2ClientFactory {
    private Textract2ClientFactory() {
    }

    public static Textract2InternalClient getTextractClient(Textract2Configuration configuration) {
        if (Boolean.TRUE.equals(configuration.isUseDefaultCredentialsProvider())) {
            return new Textract2ClientIAMOptimized(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseProfileCredentialsProvider())) {
            return new Textract2ClientIAMProfileOptimized(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseSessionCredentials())) {
            return new Textract2ClientSessionTokenImpl(configuration);
        }
        return new Textract2ClientStandardImpl(configuration);
    }
}

