/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.textract;

import java.util.Collection;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.textract.Textract2Configuration;
import org.apache.camel.component.aws2.textract.Textract2Endpoint;
import org.apache.camel.component.aws2.textract.Textract2Operations;
import org.apache.camel.component.aws2.textract.Textract2ProducerHealthCheck;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.WritableHealthCheckRepository;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.textract.TextractClient;
import software.amazon.awssdk.services.textract.model.AnalyzeDocumentRequest;
import software.amazon.awssdk.services.textract.model.AnalyzeDocumentResponse;
import software.amazon.awssdk.services.textract.model.AnalyzeExpenseRequest;
import software.amazon.awssdk.services.textract.model.AnalyzeExpenseResponse;
import software.amazon.awssdk.services.textract.model.DetectDocumentTextRequest;
import software.amazon.awssdk.services.textract.model.DetectDocumentTextResponse;
import software.amazon.awssdk.services.textract.model.Document;
import software.amazon.awssdk.services.textract.model.DocumentLocation;
import software.amazon.awssdk.services.textract.model.FeatureType;
import software.amazon.awssdk.services.textract.model.GetDocumentAnalysisRequest;
import software.amazon.awssdk.services.textract.model.GetDocumentAnalysisResponse;
import software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionRequest;
import software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionResponse;
import software.amazon.awssdk.services.textract.model.GetExpenseAnalysisRequest;
import software.amazon.awssdk.services.textract.model.GetExpenseAnalysisResponse;
import software.amazon.awssdk.services.textract.model.S3Object;
import software.amazon.awssdk.services.textract.model.StartDocumentAnalysisRequest;
import software.amazon.awssdk.services.textract.model.StartDocumentAnalysisResponse;
import software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionRequest;
import software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionResponse;
import software.amazon.awssdk.services.textract.model.StartExpenseAnalysisRequest;
import software.amazon.awssdk.services.textract.model.StartExpenseAnalysisResponse;

public class Textract2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(Textract2Producer.class);
    private transient String textractProducerToString;
    private HealthCheck producerHealthCheck;
    private WritableHealthCheckRepository healthCheckRepository;

    public Textract2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case detectDocumentText: {
                this.detectDocumentText(this.getEndpoint().getTextractClient(), exchange);
                break;
            }
            case analyzeDocument: {
                this.analyzeDocument(this.getEndpoint().getTextractClient(), exchange);
                break;
            }
            case analyzeExpense: {
                this.analyzeExpense(this.getEndpoint().getTextractClient(), exchange);
                break;
            }
            case startDocumentTextDetection: {
                this.startDocumentTextDetection(this.getEndpoint().getTextractClient(), exchange);
                break;
            }
            case startDocumentAnalysis: {
                this.startDocumentAnalysis(this.getEndpoint().getTextractClient(), exchange);
                break;
            }
            case startExpenseAnalysis: {
                this.startExpenseAnalysis(this.getEndpoint().getTextractClient(), exchange);
                break;
            }
            case getDocumentTextDetection: {
                this.getDocumentTextDetection(this.getEndpoint().getTextractClient(), exchange);
                break;
            }
            case getDocumentAnalysis: {
                this.getDocumentAnalysis(this.getEndpoint().getTextractClient(), exchange);
                break;
            }
            case getExpenseAnalysis: {
                this.getExpenseAnalysis(this.getEndpoint().getTextractClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private Textract2Operations determineOperation(Exchange exchange) {
        Textract2Operations operation = (Textract2Operations)((Object)exchange.getIn().getHeader("CamelAwsTextractOperation", Textract2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected Textract2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.textractProducerToString == null) {
            this.textractProducerToString = "TextractProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.textractProducerToString;
    }

    public Textract2Endpoint getEndpoint() {
        return (Textract2Endpoint)super.getEndpoint();
    }

    private void detectDocumentText(TextractClient textractClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DetectDocumentTextRequest) {
                DetectDocumentTextResponse result;
                try {
                    result = textractClient.detectDocumentText((DetectDocumentTextRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Detect Document Text command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Textract2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DetectDocumentTextResponse result;
            DetectDocumentTextRequest.Builder request = DetectDocumentTextRequest.builder();
            Document document = this.createDocumentFromExchange(exchange);
            request.document(document);
            try {
                result = textractClient.detectDocumentText((DetectDocumentTextRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Detect Document Text command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Textract2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void analyzeDocument(TextractClient textractClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof AnalyzeDocumentRequest) {
                AnalyzeDocumentResponse result;
                try {
                    result = textractClient.analyzeDocument((AnalyzeDocumentRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Analyze Document command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Textract2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            AnalyzeDocumentResponse result;
            AnalyzeDocumentRequest.Builder request = AnalyzeDocumentRequest.builder();
            Document document = this.createDocumentFromExchange(exchange);
            request.document(document);
            List featureTypes = (List)exchange.getIn().getHeader("CamelAwsTextractFeatureTypes", List.class);
            if (featureTypes != null && !featureTypes.isEmpty()) {
                request.featureTypes((Collection)featureTypes);
            } else {
                request.featureTypes(new FeatureType[]{FeatureType.TABLES, FeatureType.FORMS});
            }
            try {
                result = textractClient.analyzeDocument((AnalyzeDocumentRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Analyze Document command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Textract2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void analyzeExpense(TextractClient textractClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof AnalyzeExpenseRequest) {
                AnalyzeExpenseResponse result;
                try {
                    result = textractClient.analyzeExpense((AnalyzeExpenseRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Analyze Expense command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Textract2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            AnalyzeExpenseResponse result;
            AnalyzeExpenseRequest.Builder request = AnalyzeExpenseRequest.builder();
            Document document = this.createDocumentFromExchange(exchange);
            request.document(document);
            try {
                result = textractClient.analyzeExpense((AnalyzeExpenseRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Analyze Expense command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Textract2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void startDocumentTextDetection(TextractClient textractClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof StartDocumentTextDetectionRequest) {
                StartDocumentTextDetectionResponse result;
                try {
                    result = textractClient.startDocumentTextDetection((StartDocumentTextDetectionRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Start Document Text Detection command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Textract2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            StartDocumentTextDetectionResponse result;
            StartDocumentTextDetectionRequest.Builder request = StartDocumentTextDetectionRequest.builder();
            DocumentLocation documentLocation = this.createDocumentLocationFromExchange(exchange);
            request.documentLocation(documentLocation);
            try {
                result = textractClient.startDocumentTextDetection((StartDocumentTextDetectionRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Start Document Text Detection command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Textract2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void startDocumentAnalysis(TextractClient textractClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof StartDocumentAnalysisRequest) {
                StartDocumentAnalysisResponse result;
                try {
                    result = textractClient.startDocumentAnalysis((StartDocumentAnalysisRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Start Document Analysis command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Textract2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            StartDocumentAnalysisResponse result;
            StartDocumentAnalysisRequest.Builder request = StartDocumentAnalysisRequest.builder();
            DocumentLocation documentLocation = this.createDocumentLocationFromExchange(exchange);
            request.documentLocation(documentLocation);
            List featureTypes = (List)exchange.getIn().getHeader("CamelAwsTextractFeatureTypes", List.class);
            if (featureTypes != null && !featureTypes.isEmpty()) {
                request.featureTypes((Collection)featureTypes);
            } else {
                request.featureTypes(new FeatureType[]{FeatureType.TABLES, FeatureType.FORMS});
            }
            try {
                result = textractClient.startDocumentAnalysis((StartDocumentAnalysisRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Start Document Analysis command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Textract2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void startExpenseAnalysis(TextractClient textractClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof StartExpenseAnalysisRequest) {
                StartExpenseAnalysisResponse result;
                try {
                    result = textractClient.startExpenseAnalysis((StartExpenseAnalysisRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Start Expense Analysis command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Textract2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            StartExpenseAnalysisResponse result;
            StartExpenseAnalysisRequest.Builder request = StartExpenseAnalysisRequest.builder();
            DocumentLocation documentLocation = this.createDocumentLocationFromExchange(exchange);
            request.documentLocation(documentLocation);
            try {
                result = textractClient.startExpenseAnalysis((StartExpenseAnalysisRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Start Expense Analysis command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Textract2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void getDocumentTextDetection(TextractClient textractClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetDocumentTextDetectionRequest) {
                GetDocumentTextDetectionResponse result;
                try {
                    result = textractClient.getDocumentTextDetection((GetDocumentTextDetectionRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Get Document Text Detection command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Textract2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            GetDocumentTextDetectionResponse result;
            String nextToken;
            GetDocumentTextDetectionRequest.Builder request = GetDocumentTextDetectionRequest.builder();
            String jobId = (String)exchange.getIn().getHeader("CamelAwsTextractJobId", String.class);
            if (ObjectHelper.isEmpty((String)jobId)) {
                jobId = (String)exchange.getIn().getBody(String.class);
            }
            if (ObjectHelper.isEmpty((String)jobId)) {
                throw new IllegalArgumentException("Job ID must be specified in header or body");
            }
            request.jobId(jobId);
            Integer maxResults = (Integer)exchange.getIn().getHeader("CamelAwsTextractMaxResults", Integer.class);
            if (maxResults != null) {
                request.maxResults(maxResults);
            }
            if (ObjectHelper.isNotEmpty((String)(nextToken = (String)exchange.getIn().getHeader("CamelAwsTextractNextToken", String.class)))) {
                request.nextToken(nextToken);
            }
            try {
                result = textractClient.getDocumentTextDetection((GetDocumentTextDetectionRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Get Document Text Detection command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Textract2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void getDocumentAnalysis(TextractClient textractClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetDocumentAnalysisRequest) {
                GetDocumentAnalysisResponse result;
                try {
                    result = textractClient.getDocumentAnalysis((GetDocumentAnalysisRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Get Document Analysis command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Textract2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            GetDocumentAnalysisResponse result;
            String nextToken;
            GetDocumentAnalysisRequest.Builder request = GetDocumentAnalysisRequest.builder();
            String jobId = (String)exchange.getIn().getHeader("CamelAwsTextractJobId", String.class);
            if (ObjectHelper.isEmpty((String)jobId)) {
                jobId = (String)exchange.getIn().getBody(String.class);
            }
            if (ObjectHelper.isEmpty((String)jobId)) {
                throw new IllegalArgumentException("Job ID must be specified in header or body");
            }
            request.jobId(jobId);
            Integer maxResults = (Integer)exchange.getIn().getHeader("CamelAwsTextractMaxResults", Integer.class);
            if (maxResults != null) {
                request.maxResults(maxResults);
            }
            if (ObjectHelper.isNotEmpty((String)(nextToken = (String)exchange.getIn().getHeader("CamelAwsTextractNextToken", String.class)))) {
                request.nextToken(nextToken);
            }
            try {
                result = textractClient.getDocumentAnalysis((GetDocumentAnalysisRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Get Document Analysis command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Textract2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void getExpenseAnalysis(TextractClient textractClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetExpenseAnalysisRequest) {
                GetExpenseAnalysisResponse result;
                try {
                    result = textractClient.getExpenseAnalysis((GetExpenseAnalysisRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Get Expense Analysis command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = Textract2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            GetExpenseAnalysisResponse result;
            String nextToken;
            GetExpenseAnalysisRequest.Builder request = GetExpenseAnalysisRequest.builder();
            String jobId = (String)exchange.getIn().getHeader("CamelAwsTextractJobId", String.class);
            if (ObjectHelper.isEmpty((String)jobId)) {
                jobId = (String)exchange.getIn().getBody(String.class);
            }
            if (ObjectHelper.isEmpty((String)jobId)) {
                throw new IllegalArgumentException("Job ID must be specified in header or body");
            }
            request.jobId(jobId);
            Integer maxResults = (Integer)exchange.getIn().getHeader("CamelAwsTextractMaxResults", Integer.class);
            if (maxResults != null) {
                request.maxResults(maxResults);
            }
            if (ObjectHelper.isNotEmpty((String)(nextToken = (String)exchange.getIn().getHeader("CamelAwsTextractNextToken", String.class)))) {
                request.nextToken(nextToken);
            }
            try {
                result = textractClient.getExpenseAnalysis((GetExpenseAnalysisRequest)request.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Get Expense Analysis command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = Textract2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private Document createDocumentFromExchange(Exchange exchange) throws InvalidPayloadException {
        String s3Bucket = this.getConfiguration().getS3Bucket();
        String s3Object = this.getConfiguration().getS3Object();
        if (ObjectHelper.isEmpty((String)s3Bucket)) {
            s3Bucket = (String)exchange.getIn().getHeader("CamelAwsTextractS3Bucket", String.class);
        }
        if (ObjectHelper.isEmpty((String)s3Object)) {
            s3Object = (String)exchange.getIn().getHeader("CamelAwsTextractS3Object", String.class);
        }
        if (ObjectHelper.isNotEmpty((String)s3Bucket) && ObjectHelper.isNotEmpty((String)s3Object)) {
            S3Object.Builder s3ObjectBuilder = S3Object.builder().bucket(s3Bucket).name(s3Object);
            String s3ObjectVersion = this.getConfiguration().getS3ObjectVersion();
            if (ObjectHelper.isEmpty((String)s3ObjectVersion)) {
                s3ObjectVersion = (String)exchange.getIn().getHeader("CamelAwsTextractS3ObjectVersion", String.class);
            }
            if (ObjectHelper.isNotEmpty((String)s3ObjectVersion)) {
                s3ObjectBuilder.version(s3ObjectVersion);
            }
            return (Document)Document.builder().s3Object((S3Object)s3ObjectBuilder.build()).build();
        }
        byte[] documentBytes = (byte[])exchange.getIn().getMandatoryBody(byte[].class);
        return (Document)Document.builder().bytes(SdkBytes.fromByteArray((byte[])documentBytes)).build();
    }

    private DocumentLocation createDocumentLocationFromExchange(Exchange exchange) {
        String s3Bucket = this.getConfiguration().getS3Bucket();
        String s3Object = this.getConfiguration().getS3Object();
        if (ObjectHelper.isEmpty((String)s3Bucket)) {
            s3Bucket = (String)exchange.getIn().getHeader("CamelAwsTextractS3Bucket", String.class);
        }
        if (ObjectHelper.isEmpty((String)s3Object)) {
            s3Object = (String)exchange.getIn().getHeader("CamelAwsTextractS3Object", String.class);
        }
        if (ObjectHelper.isEmpty((String)s3Bucket) || ObjectHelper.isEmpty((String)s3Object)) {
            throw new IllegalArgumentException("S3 bucket and object must be specified for async operations");
        }
        S3Object.Builder s3ObjectBuilder = S3Object.builder().bucket(s3Bucket).name(s3Object);
        String s3ObjectVersion = this.getConfiguration().getS3ObjectVersion();
        if (ObjectHelper.isEmpty((String)s3ObjectVersion)) {
            s3ObjectVersion = (String)exchange.getIn().getHeader("CamelAwsTextractS3ObjectVersion", String.class);
        }
        if (ObjectHelper.isNotEmpty((String)s3ObjectVersion)) {
            s3ObjectBuilder.version(s3ObjectVersion);
        }
        return (DocumentLocation)DocumentLocation.builder().s3Object((S3Object)s3ObjectBuilder.build()).build();
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    protected void doStart() throws Exception {
        this.healthCheckRepository = (WritableHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getEndpoint().getCamelContext(), (String)"producers", WritableHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            String id = this.getEndpoint().getId();
            this.producerHealthCheck = new Textract2ProducerHealthCheck(this.getEndpoint(), id);
            this.producerHealthCheck.setEnabled(this.getEndpoint().getComponent().isHealthCheckProducerEnabled());
            this.healthCheckRepository.addHealthCheck(this.producerHealthCheck);
        }
    }

    protected void doStop() throws Exception {
        if (this.healthCheckRepository != null && this.producerHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck(this.producerHealthCheck);
            this.producerHealthCheck = null;
        }
    }
}

