/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.textract;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.textract.Textract2Component;
import org.apache.camel.component.aws2.textract.Textract2Configuration;
import org.apache.camel.component.aws2.textract.Textract2Constants;
import org.apache.camel.component.aws2.textract.Textract2Producer;
import org.apache.camel.component.aws2.textract.client.Textract2ClientFactory;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.textract.TextractClient;

@UriEndpoint(firstVersion="4.15.0", scheme="aws2-textract", title="AWS Textract", syntax="aws2-textract:label", producerOnly=true, category={Category.CLOUD, Category.DOCUMENT}, headersClass=Textract2Constants.class)
public class Textract2Endpoint
extends ScheduledPollEndpoint
implements EndpointServiceLocation {
    private TextractClient textractClient;
    @UriParam
    private Textract2Configuration configuration;

    public Textract2Endpoint(String uri, Component component, Textract2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new Textract2Producer((Endpoint)this);
    }

    public Textract2Component getComponent() {
        return (Textract2Component)super.getComponent();
    }

    public void doStart() throws Exception {
        super.doStart();
        this.textractClient = this.configuration.getTextractClient() != null ? this.configuration.getTextractClient() : Textract2ClientFactory.getTextractClient(this.configuration).getTextractClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getTextractClient()) && this.textractClient != null) {
            this.textractClient.close();
        }
        super.doStop();
    }

    public Textract2Configuration getConfiguration() {
        return this.configuration;
    }

    public TextractClient getTextractClient() {
        return this.textractClient;
    }

    public String getServiceUrl() {
        if (!this.configuration.isOverrideEndpoint()) {
            if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
                return this.configuration.getRegion();
            }
        } else if (ObjectHelper.isNotEmpty((String)this.configuration.getUriEndpointOverride())) {
            return this.configuration.getUriEndpointOverride();
        }
        return null;
    }

    public String getServiceProtocol() {
        return "textract";
    }
}

