/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sts;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.sts.STS2Configuration;
import org.apache.camel.component.aws2.sts.STS2Constants;
import org.apache.camel.component.aws2.sts.STS2Producer;
import org.apache.camel.component.aws2.sts.client.STS2ClientFactory;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.sts.StsClient;

@UriEndpoint(firstVersion="3.5.0", scheme="aws2-sts", title="AWS Security Token Service (STS)", syntax="aws2-sts:label", producerOnly=true, category={Category.CLOUD, Category.MANAGEMENT}, headersClass=STS2Constants.class)
public class STS2Endpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    private StsClient stsClient;
    @UriParam
    private STS2Configuration configuration;

    public STS2Endpoint(String uri, Component component, STS2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new STS2Producer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.stsClient = this.configuration.getStsClient() != null ? this.configuration.getStsClient() : STS2ClientFactory.getStsClient(this.configuration).getStsClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getStsClient()) && this.stsClient != null) {
            this.stsClient.close();
        }
        super.doStop();
    }

    public STS2Configuration getConfiguration() {
        return this.configuration;
    }

    public StsClient getStsClient() {
        return this.stsClient;
    }

    public String getServiceUrl() {
        if (!this.configuration.isOverrideEndpoint()) {
            if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
                return this.configuration.getRegion();
            }
        } else if (ObjectHelper.isNotEmpty((String)this.configuration.getUriEndpointOverride())) {
            return this.configuration.getUriEndpointOverride();
        }
        return null;
    }

    public String getServiceProtocol() {
        return "sts";
    }
}

