/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sqs;

import java.nio.ByteBuffer;
import java.util.Date;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;

public final class Sqs2MessageHelper {
    public static final String TYPE_STRING = "String";
    public static final String TYPE_BINARY = "Binary";

    private Sqs2MessageHelper() {
    }

    public static MessageAttributeValue toMessageAttributeValue(Object value) {
        if (value instanceof String && !((String)value).isEmpty()) {
            MessageAttributeValue.Builder mav = MessageAttributeValue.builder();
            mav.dataType(TYPE_STRING);
            mav.stringValue((String)value);
            return (MessageAttributeValue)mav.build();
        }
        if (value instanceof ByteBuffer) {
            MessageAttributeValue.Builder mav = MessageAttributeValue.builder();
            mav.dataType(TYPE_BINARY);
            mav.binaryValue(SdkBytes.fromByteBuffer((ByteBuffer)((ByteBuffer)value)));
            return (MessageAttributeValue)mav.build();
        }
        if (value instanceof byte[]) {
            MessageAttributeValue.Builder mav = MessageAttributeValue.builder();
            mav.dataType(TYPE_BINARY);
            mav.binaryValue(SdkBytes.fromByteArray((byte[])((byte[])value)));
            return (MessageAttributeValue)mav.build();
        }
        if (value instanceof Boolean) {
            MessageAttributeValue.Builder mav = MessageAttributeValue.builder();
            mav.dataType("Number.Boolean");
            mav.stringValue(Boolean.TRUE.equals(value) ? "1" : "0");
            return (MessageAttributeValue)mav.build();
        }
        if (value instanceof Number) {
            MessageAttributeValue.Builder mav = MessageAttributeValue.builder();
            String dataType = value instanceof Integer ? "Number.int" : (value instanceof Byte ? "Number.byte" : (value instanceof Double ? "Number.double" : (value instanceof Float ? "Number.float" : (value instanceof Long ? "Number.long" : (value instanceof Short ? "Number.short" : "Number")))));
            mav.dataType(dataType);
            mav.stringValue(value.toString());
            return (MessageAttributeValue)mav.build();
        }
        if (value instanceof Date) {
            MessageAttributeValue.Builder mav = MessageAttributeValue.builder();
            mav.dataType(TYPE_STRING);
            mav.stringValue(value.toString());
            return (MessageAttributeValue)mav.build();
        }
        return null;
    }

    public static Object fromMessageAttributeValue(MessageAttributeValue mav) {
        if (mav == null) {
            return null;
        }
        if (mav.binaryValue() != null) {
            return mav.binaryValue();
        }
        if (mav.stringValue() != null) {
            String s = mav.stringValue();
            String dt = mav.dataType();
            if (dt == null || TYPE_STRING.equals(dt)) {
                return s;
            }
            if ("Number.Boolean".equals(dt)) {
                return "1".equals(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if ("Number.int".equals(dt)) {
                return Integer.valueOf(s);
            }
            if ("Number.byte".equals(dt)) {
                return Byte.valueOf(s);
            }
            if ("Number.double".equals(dt)) {
                return Double.valueOf(s);
            }
            if ("Number.float".equals(dt)) {
                return Float.valueOf(s);
            }
            if ("Number.long".equals(dt)) {
                return Long.valueOf(s);
            }
            if ("Number.short".equals(dt)) {
                return Short.valueOf(s);
            }
            return s;
        }
        return null;
    }
}

