/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sns;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class Sns2EndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":topicNameOrArn";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Map<String, String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "aws2-sns".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "topicNameOrArn", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Map<String, String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(29);
        props.add("accessKey");
        props.add("amazonSNSClient");
        props.add("autoCreateTopic");
        props.add("batchEnabled");
        props.add("headerFilterStrategy");
        props.add("kmsMasterKeyId");
        props.add("lazyStartProducer");
        props.add("messageDeduplicationIdStrategy");
        props.add("messageGroupIdStrategy");
        props.add("messageStructure");
        props.add("overrideEndpoint");
        props.add("policy");
        props.add("profileCredentialsName");
        props.add("proxyHost");
        props.add("proxyPort");
        props.add("proxyProtocol");
        props.add("queueArn");
        props.add("region");
        props.add("secretKey");
        props.add("serverSideEncryptionEnabled");
        props.add("sessionToken");
        props.add("subject");
        props.add("subscribeSNStoSQS");
        props.add("topicNameOrArn");
        props.add("trustAllCertificates");
        props.add("uriEndpointOverride");
        props.add("useDefaultCredentialsProvider");
        props.add("useProfileCredentialsProvider");
        props.add("useSessionCredentials");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(3);
        secretProps.add("accessKey");
        secretProps.add("secretKey");
        secretProps.add("sessionToken");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptyMap();
    }
}

