/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sns;

import java.util.Map;
import org.apache.camel.component.aws2.sns.Sns2Configuration;
import org.apache.camel.component.aws2.sns.Sns2Endpoint;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sns.SnsClient;

public class Sns2ProducerHealthCheck
extends AbstractHealthCheck {
    private final Sns2Endpoint sns2Endpoint;

    public Sns2ProducerHealthCheck(Sns2Endpoint sns2Endpoint, String clientId) {
        super("camel", "producer:aws2-sns-" + clientId);
        this.sns2Endpoint = sns2Endpoint;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        Sns2Configuration configuration = this.sns2Endpoint.getConfiguration();
        try {
            if (!SnsClient.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
                builder.message("The service is not supported in this region");
                builder.down();
                return;
            }
            SnsClient client = this.sns2Endpoint.getSNSClient();
            client.listSubscriptions();
        }
        catch (AwsServiceException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            builder.down();
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

