/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.msk;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.msk.MSK2Configuration;
import org.apache.camel.component.aws2.msk.MSK2Endpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.HealthCheckComponent;

@org.apache.camel.spi.annotations.Component(value="aws2-msk")
public class MSK2Component
extends HealthCheckComponent {
    @Metadata
    private MSK2Configuration configuration = new MSK2Configuration();

    public MSK2Component() {
        this(null);
    }

    public MSK2Component(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MSK2Configuration configuration = this.configuration != null ? this.configuration.copy() : new MSK2Configuration();
        MSK2Endpoint endpoint = new MSK2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (Boolean.FALSE.equals(configuration.isUseDefaultCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseProfileCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseSessionCredentials()) && configuration.getMskClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, useProfileCredentialsProvider is set to false, Amazon msk client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public MSK2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MSK2Configuration configuration) {
        this.configuration = configuration;
    }
}

