/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.mq;

import java.util.Collection;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.mq.MQ2Configuration;
import org.apache.camel.component.aws2.mq.MQ2Endpoint;
import org.apache.camel.component.aws2.mq.MQ2Operations;
import org.apache.camel.component.aws2.mq.MQ2ProducerHealthCheck;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.WritableHealthCheckRepository;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.mq.MqClient;
import software.amazon.awssdk.services.mq.model.ConfigurationId;
import software.amazon.awssdk.services.mq.model.CreateBrokerRequest;
import software.amazon.awssdk.services.mq.model.CreateBrokerResponse;
import software.amazon.awssdk.services.mq.model.DeleteBrokerRequest;
import software.amazon.awssdk.services.mq.model.DeleteBrokerResponse;
import software.amazon.awssdk.services.mq.model.DeploymentMode;
import software.amazon.awssdk.services.mq.model.DescribeBrokerRequest;
import software.amazon.awssdk.services.mq.model.DescribeBrokerResponse;
import software.amazon.awssdk.services.mq.model.EngineType;
import software.amazon.awssdk.services.mq.model.ListBrokersRequest;
import software.amazon.awssdk.services.mq.model.ListBrokersResponse;
import software.amazon.awssdk.services.mq.model.RebootBrokerRequest;
import software.amazon.awssdk.services.mq.model.RebootBrokerResponse;
import software.amazon.awssdk.services.mq.model.UpdateBrokerRequest;
import software.amazon.awssdk.services.mq.model.UpdateBrokerResponse;

public class MQ2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MQ2Producer.class);
    public static final String MISSING_BROKER_NAME = "Broker Name must be specified";
    private transient String mqProducerToString;
    private HealthCheck producerHealthCheck;
    private WritableHealthCheckRepository healthCheckRepository;

    public MQ2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case listBrokers: {
                this.listBrokers(this.getEndpoint().getAmazonMqClient(), exchange);
                break;
            }
            case createBroker: {
                this.createBroker(this.getEndpoint().getAmazonMqClient(), exchange);
                break;
            }
            case deleteBroker: {
                this.deleteBroker(this.getEndpoint().getAmazonMqClient(), exchange);
                break;
            }
            case rebootBroker: {
                this.rebootBroker(this.getEndpoint().getAmazonMqClient(), exchange);
                break;
            }
            case updateBroker: {
                this.updateBroker(this.getEndpoint().getAmazonMqClient(), exchange);
                break;
            }
            case describeBroker: {
                this.describeBroker(this.getEndpoint().getAmazonMqClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private MQ2Operations determineOperation(Exchange exchange) {
        MQ2Operations operation = (MQ2Operations)((Object)exchange.getIn().getHeader("CamelAwsMQOperation", MQ2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected MQ2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.mqProducerToString == null) {
            this.mqProducerToString = "MQProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.mqProducerToString;
    }

    public MQ2Endpoint getEndpoint() {
        return (MQ2Endpoint)super.getEndpoint();
    }

    private void listBrokers(MqClient mqClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListBrokersRequest) {
                ListBrokersResponse result;
                try {
                    result = mqClient.listBrokers((ListBrokersRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("List Brokers command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = MQ2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListBrokersResponse result;
            ListBrokersRequest.Builder builder = ListBrokersRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQMaxResults"))) {
                int maxResults = (Integer)exchange.getIn().getHeader("CamelAwsMQMaxResults", Integer.class);
                builder.maxResults(Integer.valueOf(maxResults));
            }
            try {
                result = mqClient.listBrokers((ListBrokersRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("List Brokers command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = MQ2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void createBroker(MqClient mqClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof CreateBrokerRequest) {
                CreateBrokerResponse result;
                try {
                    result = mqClient.createBroker((CreateBrokerRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Create Broker command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = MQ2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            CreateBrokerResponse result;
            CreateBrokerRequest.Builder builder = CreateBrokerRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerName"))) {
                throw new IllegalArgumentException(MISSING_BROKER_NAME);
            }
            String brokerName = (String)exchange.getIn().getHeader("CamelAwsMQBrokerName", String.class);
            builder.brokerName(brokerName);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerEngine"))) {
                throw new IllegalArgumentException("A broker engine must be specified, it can be ACTIVEMQ or RABBITMQ");
            }
            String brokerEngine = (String)exchange.getIn().getHeader("CamelAwsMQBrokerEngine", String.class);
            builder.engineType(EngineType.fromValue((String)brokerEngine));
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerEngineVersion"))) {
                throw new IllegalArgumentException("Broker Engine Version must be specified");
            }
            String brokerEngineVersion = (String)exchange.getIn().getHeader("CamelAwsMQBrokerEngineVersion", String.class);
            builder.engineVersion(brokerEngineVersion);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerDeploymentMode"))) {
                throw new IllegalArgumentException("Deployment Mode must be specified");
            }
            String deploymentMode = (String)exchange.getIn().getHeader("CamelAwsMQBrokerDeploymentMode", String.class);
            builder.deploymentMode(DeploymentMode.fromValue((String)deploymentMode));
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerInstanceType"))) {
                throw new IllegalArgumentException("Instance Type must be specified");
            }
            String instanceType = (String)exchange.getIn().getHeader("CamelAwsMQBrokerInstanceType", String.class);
            builder.hostInstanceType(instanceType);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerUsers"))) {
                throw new IllegalArgumentException("A Users list must be specified");
            }
            List users = (List)exchange.getIn().getHeader("CamelAwsMQBrokerUsers", List.class);
            builder.users((Collection)users);
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerPubliclyAccessible"))) {
                Boolean publiclyAccessible = (Boolean)exchange.getIn().getHeader("CamelAwsMQBrokerPubliclyAccessible", Boolean.class);
                builder.publiclyAccessible(publiclyAccessible);
            } else {
                builder.publiclyAccessible(Boolean.valueOf(false));
            }
            try {
                result = mqClient.createBroker((CreateBrokerRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Create Broker command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = MQ2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void deleteBroker(MqClient mqClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteBrokerRequest) {
                DeleteBrokerResponse result;
                try {
                    result = mqClient.deleteBroker((DeleteBrokerRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Delete Broker command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = MQ2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DeleteBrokerResponse result;
            DeleteBrokerRequest.Builder builder = DeleteBrokerRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerID"))) {
                throw new IllegalArgumentException(MISSING_BROKER_NAME);
            }
            String brokerId = (String)exchange.getIn().getHeader("CamelAwsMQBrokerID", String.class);
            builder.brokerId(brokerId);
            try {
                result = mqClient.deleteBroker((DeleteBrokerRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Delete Broker command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = MQ2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void rebootBroker(MqClient mqClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof RebootBrokerRequest) {
                RebootBrokerResponse result;
                try {
                    result = mqClient.rebootBroker((RebootBrokerRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Reboot Broker command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = MQ2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            RebootBrokerResponse result;
            RebootBrokerRequest.Builder builder = RebootBrokerRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerID"))) {
                throw new IllegalArgumentException(MISSING_BROKER_NAME);
            }
            String brokerId = (String)exchange.getIn().getHeader("CamelAwsMQBrokerID", String.class);
            builder.brokerId(brokerId);
            try {
                result = mqClient.rebootBroker((RebootBrokerRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Reboot Broker command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = MQ2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void updateBroker(MqClient mqClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof UpdateBrokerRequest) {
                UpdateBrokerResponse result;
                try {
                    result = mqClient.updateBroker((UpdateBrokerRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Update Broker command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = MQ2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            UpdateBrokerResponse result;
            UpdateBrokerRequest.Builder builder = UpdateBrokerRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerID"))) {
                throw new IllegalArgumentException(MISSING_BROKER_NAME);
            }
            String brokerId = (String)exchange.getIn().getHeader("CamelAwsMQBrokerID", String.class);
            builder.brokerId(brokerId);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQConfigurationID"))) {
                throw new IllegalArgumentException(MISSING_BROKER_NAME);
            }
            ConfigurationId configurationId = (ConfigurationId)exchange.getIn().getHeader("CamelAwsMQConfigurationID", ConfigurationId.class);
            builder.configuration(configurationId);
            try {
                result = mqClient.updateBroker((UpdateBrokerRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Update Broker command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = MQ2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void describeBroker(MqClient mqClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DescribeBrokerRequest) {
                DescribeBrokerResponse result;
                try {
                    result = mqClient.describeBroker((DescribeBrokerRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Reboot Broker command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = MQ2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DescribeBrokerResponse result;
            DescribeBrokerRequest.Builder builder = DescribeBrokerRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsMQBrokerID"))) {
                throw new IllegalArgumentException(MISSING_BROKER_NAME);
            }
            String brokerId = (String)exchange.getIn().getHeader("CamelAwsMQBrokerID", String.class);
            builder.brokerId(brokerId);
            try {
                result = mqClient.describeBroker((DescribeBrokerRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Reboot Broker command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = MQ2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    protected void doStart() throws Exception {
        this.healthCheckRepository = (WritableHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getEndpoint().getCamelContext(), (String)"producers", WritableHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            String id = this.getEndpoint().getId();
            this.producerHealthCheck = new MQ2ProducerHealthCheck(this.getEndpoint(), id);
            this.producerHealthCheck.setEnabled(this.getEndpoint().getComponent().isHealthCheckProducerEnabled());
            this.healthCheckRepository.addHealthCheck(this.producerHealthCheck);
        }
    }

    protected void doStop() throws Exception {
        if (this.healthCheckRepository != null && this.producerHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck(this.producerHealthCheck);
            this.producerHealthCheck = null;
        }
    }
}

