/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.kinesis.KclKinesis2Consumer;
import org.apache.camel.component.aws2.kinesis.Kinesis2Component;
import org.apache.camel.component.aws2.kinesis.Kinesis2Configuration;
import org.apache.camel.component.aws2.kinesis.Kinesis2Constants;
import org.apache.camel.component.aws2.kinesis.Kinesis2Consumer;
import org.apache.camel.component.aws2.kinesis.Kinesis2Producer;
import org.apache.camel.component.aws2.kinesis.KinesisConnection;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

@UriEndpoint(firstVersion="3.2.0", scheme="aws2-kinesis", title="AWS Kinesis", syntax="aws2-kinesis:streamName", category={Category.CLOUD, Category.MESSAGING}, headersClass=Kinesis2Constants.class)
public class Kinesis2Endpoint
extends ScheduledPollEndpoint
implements EndpointServiceLocation {
    @UriParam
    private Kinesis2Configuration configuration;
    private KinesisClient kinesisClient;
    private KinesisAsyncClient kinesisAsyncClient;

    public Kinesis2Endpoint(String uri, Kinesis2Configuration configuration, Kinesis2Component component) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        KinesisConnection kinesisConnection = this.getComponent().getConnection();
        if (!this.configuration.isCborEnabled()) {
            System.setProperty(SdkSystemSetting.CBOR_ENABLED.property(), "false");
        }
        if (this.configuration.isAsyncClient() && Objects.isNull(this.configuration.getAmazonKinesisAsyncClient())) {
            this.kinesisAsyncClient = kinesisConnection.getAsyncClient(this);
        } else {
            this.kinesisClient = kinesisConnection.getClient(this);
        }
        if ((this.configuration.getIteratorType().equals((Object)ShardIteratorType.AFTER_SEQUENCE_NUMBER) || this.configuration.getIteratorType().equals((Object)ShardIteratorType.AT_SEQUENCE_NUMBER)) && this.configuration.getSequenceNumber().isEmpty()) {
            throw new IllegalArgumentException("Sequence Number must be specified with iterator Types AFTER_SEQUENCE_NUMBER or AT_SEQUENCE_NUMBER");
        }
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonKinesisClient())) {
            if (this.kinesisClient != null) {
                this.kinesisClient.close();
            } else if (Objects.nonNull(this.kinesisAsyncClient)) {
                this.kinesisAsyncClient.close();
            }
        }
        if (!this.configuration.isCborEnabled()) {
            System.clearProperty(SdkSystemSetting.CBOR_ENABLED.property());
        }
        super.doStop();
    }

    public Producer createProducer() throws Exception {
        Kinesis2Producer producer = new Kinesis2Producer(this);
        producer.setConnection(this.getComponent().getConnection());
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (!this.getConfiguration().isUseKclConsumers()) {
            Kinesis2Consumer consumer = new Kinesis2Consumer(this, processor);
            consumer.setConnection(this.getComponent().getConnection());
            consumer.setSchedulerProperties(this.getSchedulerProperties());
            this.configureConsumer((Consumer)consumer);
            return consumer;
        }
        KclKinesis2Consumer consumer = new KclKinesis2Consumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Kinesis2Component getComponent() {
        return (Kinesis2Component)super.getComponent();
    }

    public KinesisClient getClient() {
        return this.kinesisClient;
    }

    public KinesisAsyncClient getAsyncClient() {
        return this.kinesisAsyncClient;
    }

    public Kinesis2Configuration getConfiguration() {
        return this.configuration;
    }

    public String getServiceUrl() {
        if (!this.configuration.isOverrideEndpoint()) {
            if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
                return this.configuration.getRegion();
            }
        } else if (ObjectHelper.isNotEmpty((String)this.configuration.getUriEndpointOverride())) {
            return this.configuration.getUriEndpointOverride();
        }
        return null;
    }

    public String getServiceProtocol() {
        return "kinesis";
    }

    public Map<String, String> getServiceMetadata() {
        if (this.configuration.getStreamName() != null) {
            return Map.of("stream", this.configuration.getStreamName());
        }
        return null;
    }

    public ExecutorService createExecutor(Object source) {
        return this.getCamelContext().getExecutorServiceManager().newFixedThreadPool(source, "KinesisStream[" + this.configuration.getStreamName() + "]", 1);
    }
}

