/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis.client;

import org.apache.camel.component.aws2.kinesis.Kinesis2Configuration;
import org.apache.camel.component.aws2.kinesis.client.KinesisAsyncInternalClient;
import org.apache.camel.component.aws2.kinesis.client.KinesisInternalClient;
import org.apache.camel.component.aws2.kinesis.client.impl.KinesisAsyncClientIAMOptimizedImpl;
import org.apache.camel.component.aws2.kinesis.client.impl.KinesisAsyncClientIAMProfileOptimizedImpl;
import org.apache.camel.component.aws2.kinesis.client.impl.KinesisAsyncClientSessionTokenImpl;
import org.apache.camel.component.aws2.kinesis.client.impl.KinesisAsyncClientStandardImpl;
import org.apache.camel.component.aws2.kinesis.client.impl.KinesisClientIAMOptimizedImpl;
import org.apache.camel.component.aws2.kinesis.client.impl.KinesisClientIAMProfileOptimizedImpl;
import org.apache.camel.component.aws2.kinesis.client.impl.KinesisClientSessionTokenImpl;
import org.apache.camel.component.aws2.kinesis.client.impl.KinesisClientStandardImpl;

public final class KinesisClientFactory {
    private KinesisClientFactory() {
    }

    public static KinesisInternalClient getKinesisClient(Kinesis2Configuration configuration) {
        if (Boolean.TRUE.equals(configuration.isUseDefaultCredentialsProvider())) {
            return new KinesisClientIAMOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseProfileCredentialsProvider())) {
            return new KinesisClientIAMProfileOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseSessionCredentials())) {
            return new KinesisClientSessionTokenImpl(configuration);
        }
        return new KinesisClientStandardImpl(configuration);
    }

    public static KinesisAsyncInternalClient getKinesisAsyncClient(Kinesis2Configuration configuration) {
        if (Boolean.TRUE.equals(configuration.isUseDefaultCredentialsProvider())) {
            return new KinesisAsyncClientIAMOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseProfileCredentialsProvider())) {
            return new KinesisAsyncClientIAMProfileOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseSessionCredentials())) {
            return new KinesisAsyncClientSessionTokenImpl(configuration);
        }
        return new KinesisAsyncClientStandardImpl(configuration);
    }
}

