/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis.client.impl;

import java.net.URI;
import org.apache.camel.component.aws2.kinesis.Kinesis2Configuration;
import org.apache.camel.component.aws2.kinesis.client.KinesisInternalClient;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.KinesisClientBuilder;
import software.amazon.awssdk.utils.AttributeMap;

public class KinesisClientSessionTokenImpl
implements KinesisInternalClient {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisClientSessionTokenImpl.class);
    private Kinesis2Configuration configuration;

    public KinesisClientSessionTokenImpl(Kinesis2Configuration configuration) {
        LOG.trace("Creating an AWS Kinesis manager using static credentials.");
        this.configuration = configuration;
    }

    @Override
    public KinesisClient getKinesisClient() {
        KinesisClient client = null;
        KinesisClientBuilder clientBuilder = KinesisClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((String)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(String.valueOf(this.configuration.getProxyProtocol()) + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null && this.configuration.getSessionToken() != null) {
            AwsSessionCredentials cred = AwsSessionCredentials.create((String)this.configuration.getAccessKey(), (String)this.configuration.getSecretKey(), (String)this.configuration.getSessionToken());
            clientBuilder = isClientConfigFound ? (KinesisClientBuilder)((KinesisClientBuilder)clientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred)) : (KinesisClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
        } else if (!isClientConfigFound) {
            clientBuilder = (KinesisClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
            clientBuilder = (KinesisClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        if (this.configuration.isOverrideEndpoint()) {
            clientBuilder.endpointOverride(URI.create(this.configuration.getUriEndpointOverride()));
        }
        if (this.configuration.isTrustAllCertificates()) {
            if (httpClientBuilder == null) {
                httpClientBuilder = ApacheHttpClient.builder();
            }
            SdkHttpClient ahc = httpClientBuilder.buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)Boolean.TRUE).build());
            clientBuilder.httpClient(ahc);
            clientBuilder.httpClientBuilder(null);
        }
        client = (KinesisClient)clientBuilder.build();
        return client;
    }
}

