/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis.consumer;

import org.apache.camel.resume.Cacheable;
import org.apache.camel.resume.ResumeStrategyConfiguration;
import org.apache.camel.resume.ResumeStrategyConfigurationBuilder;
import org.apache.camel.resume.cache.ResumeCache;

public class KinesisResumeStrategyConfiguration
extends ResumeStrategyConfiguration {
    private KinesisResumeStrategyConfiguration() {
    }

    public String resumeStrategyService() {
        return "kinesis-resume-strategy";
    }

    public static KinesisResumeStrategyConfigurationBuilder builder() {
        return new KinesisResumeStrategyConfigurationBuilder();
    }

    public static class KinesisResumeStrategyConfigurationBuilder
    implements ResumeStrategyConfigurationBuilder<KinesisResumeStrategyConfigurationBuilder, KinesisResumeStrategyConfiguration> {
        private Cacheable.FillPolicy fillPolicy = Cacheable.FillPolicy.MAXIMIZING;
        private ResumeCache resumeCache;

        private KinesisResumeStrategyConfigurationBuilder() {
        }

        public KinesisResumeStrategyConfigurationBuilder withCacheFillPolicy(Cacheable.FillPolicy cacheFillPolicy) {
            this.fillPolicy = cacheFillPolicy;
            return this;
        }

        public KinesisResumeStrategyConfigurationBuilder withResumeCache(ResumeCache<?> resumeCache) {
            this.resumeCache = resumeCache;
            return this;
        }

        public KinesisResumeStrategyConfiguration build() {
            KinesisResumeStrategyConfiguration result = new KinesisResumeStrategyConfiguration();
            result.setResumeCache(this.resumeCache);
            result.setCacheFillPolicy(this.fillPolicy);
            return result;
        }
    }
}

