/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.firehose;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2ComponentVerifierExtension;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Configuration;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="aws2-kinesis-firehose")
public class KinesisFirehose2Component
extends DefaultComponent {
    @Metadata
    private KinesisFirehose2Configuration configuration = new KinesisFirehose2Configuration();

    public KinesisFirehose2Component() {
        this(null);
    }

    public KinesisFirehose2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new KinesisFirehose2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        KinesisFirehose2Configuration configuration = this.configuration != null ? this.configuration.copy() : new KinesisFirehose2Configuration();
        configuration.setStreamName(remaining);
        KinesisFirehose2Endpoint endpoint = new KinesisFirehose2Endpoint(uri, configuration, this);
        this.setProperties((Endpoint)endpoint, parameters);
        if (!(configuration.isUseDefaultCredentialsProvider() || configuration.isUseSessionCredentials() || configuration.isUseProfileCredentialsProvider() || configuration.getAmazonKinesisFirehoseClient() != null || configuration.getAccessKey() != null && configuration.getSecretKey() != null)) {
            throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, useProfileCredentialsProvider is set to false, AmazonKinesisFirehoseClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public KinesisFirehose2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KinesisFirehose2Configuration configuration) {
        this.configuration = configuration;
    }
}

