/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kinesis;

import java.nio.ByteBuffer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.kinesis.Kinesis2Endpoint;
import org.apache.camel.support.DefaultProducer;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordResponse;

public class Kinesis2Producer
extends DefaultProducer {
    public Kinesis2Producer(Kinesis2Endpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public Kinesis2Endpoint getEndpoint() {
        return (Kinesis2Endpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        PutRecordRequest request = this.createRequest(exchange);
        PutRecordResponse putRecordResult = this.getEndpoint().getClient().putRecord(request);
        Message message = Kinesis2Producer.getMessageForResponse(exchange);
        message.setHeader("CamelAwsKinesisSequenceNumber", (Object)putRecordResult.sequenceNumber());
        message.setHeader("CamelAwsKinesisShardId", (Object)putRecordResult.shardId());
    }

    private PutRecordRequest createRequest(Exchange exchange) {
        ByteBuffer body = (ByteBuffer)exchange.getIn().getBody(ByteBuffer.class);
        Object partitionKey = exchange.getIn().getHeader("CamelAwsKinesisPartitionKey");
        Object sequenceNumber = exchange.getIn().getHeader("CamelAwsKinesisSequenceNumber");
        PutRecordRequest.Builder putRecordRequest = PutRecordRequest.builder();
        putRecordRequest.data(SdkBytes.fromByteBuffer((ByteBuffer)body));
        putRecordRequest.streamName(this.getEndpoint().getConfiguration().getStreamName());
        putRecordRequest.partitionKey(partitionKey.toString());
        if (sequenceNumber != null) {
            putRecordRequest.sequenceNumberForOrdering(sequenceNumber.toString());
        }
        return (PutRecordRequest)putRecordRequest.build();
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

