/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ec2;

import java.util.Map;
import org.apache.camel.component.aws2.ec2.AWS2EC2Configuration;
import org.apache.camel.component.aws2.ec2.AWS2EC2Endpoint;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2.Ec2Client;

public class AWS2EC2ProducerHealthCheck
extends AbstractHealthCheck {
    private final AWS2EC2Endpoint aws2EC2Endpoint;

    public AWS2EC2ProducerHealthCheck(AWS2EC2Endpoint aws2EC2Endpoint, String clientId) {
        super("camel", "producer:aws2-ec2-" + clientId);
        this.aws2EC2Endpoint = aws2EC2Endpoint;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        try {
            AWS2EC2Configuration configuration = this.aws2EC2Endpoint.getConfiguration();
            if (!Ec2Client.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
                builder.message("The service is not supported in this region");
                builder.down();
                return;
            }
            Ec2Client client = this.aws2EC2Endpoint.getEc2Client();
            client.describeInstances();
        }
        catch (AwsServiceException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            if (ObjectHelper.isNotEmpty((Object)e.statusCode())) {
                builder.detail("service.status.code", (Object)e.statusCode());
            }
            if (ObjectHelper.isNotEmpty((String)e.awsErrorDetails().errorCode())) {
                builder.detail("service.error.code", (Object)e.awsErrorDetails().errorCode());
            }
            builder.down();
            return;
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

