/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddbstream;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamConfiguration;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamEndpoint;
import org.apache.camel.component.aws2.ddbstream.ShardTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse;
import software.amazon.awssdk.services.dynamodb.model.Shard;
import software.amazon.awssdk.services.dynamodb.model.ShardIteratorType;
import software.amazon.awssdk.services.dynamodb.model.Stream;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;

class ShardIteratorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ShardIteratorHandler.class);
    private final Ddb2StreamEndpoint endpoint;
    private final ShardTree shardTree = new ShardTree();
    private String streamArn;
    private Map<String, String> currentShardIterators = new HashMap<String, String>();

    ShardIteratorHandler(Ddb2StreamEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    Map<String, String> getShardIterators() {
        if (this.streamArn == null) {
            this.streamArn = this.getStreamArn();
        }
        if (this.currentShardIterators.isEmpty()) {
            DescribeStreamResponse streamDescriptionResult = this.getClient().describeStream((DescribeStreamRequest)DescribeStreamRequest.builder().streamArn(this.streamArn).build());
            this.shardTree.populate(streamDescriptionResult.streamDescription().shards());
            Ddb2StreamConfiguration.StreamIteratorType streamIteratorType = this.getEndpoint().getConfiguration().getStreamIteratorType();
            this.currentShardIterators = this.getCurrentShardIterators(streamIteratorType);
        } else {
            HashMap<String, String> childShardIterators = new HashMap<String, String>();
            for (Map.Entry<String, String> currentShardIterator : this.currentShardIterators.entrySet()) {
                List<Shard> children = this.shardTree.getChildren(currentShardIterator.getKey());
                if (children.isEmpty()) {
                    childShardIterators.put(currentShardIterator.getKey(), currentShardIterator.getValue());
                    continue;
                }
                for (Shard child : children) {
                    String shardIterator = this.getShardIterator(child.shardId(), ShardIteratorType.TRIM_HORIZON);
                    childShardIterators.put(child.shardId(), shardIterator);
                }
            }
            this.currentShardIterators = childShardIterators;
        }
        LOG.trace("Shard Iterators are: {}", this.currentShardIterators);
        return this.currentShardIterators;
    }

    void updateShardIterator(String shardId, String nextShardIterator) {
        if (nextShardIterator == null) {
            this.currentShardIterators.remove(shardId);
        } else {
            this.currentShardIterators.put(shardId, nextShardIterator);
        }
    }

    String requestFreshShardIterator(String shardId, String lastSeenSequenceNumber) {
        String shardIterator = this.getShardIterator(shardId, ShardIteratorType.AFTER_SEQUENCE_NUMBER, lastSeenSequenceNumber);
        this.currentShardIterators.put(shardId, shardIterator);
        return shardIterator;
    }

    Ddb2StreamEndpoint getEndpoint() {
        return this.endpoint;
    }

    private String getStreamArn() {
        ListStreamsResponse streamsListResult = this.getClient().listStreams((ListStreamsRequest)ListStreamsRequest.builder().tableName(this.getEndpoint().getConfiguration().getTableName()).build());
        if (streamsListResult.streams().isEmpty()) {
            throw new IllegalArgumentException("There is no stream associated with table configured. Please create one.");
        }
        return ((Stream)streamsListResult.streams().get(0)).streamArn();
    }

    private Map<String, String> getCurrentShardIterators(Ddb2StreamConfiguration.StreamIteratorType streamIteratorType) {
        List<Shard> currentShards;
        ShardIteratorType shardIteratorType = switch (streamIteratorType) {
            case Ddb2StreamConfiguration.StreamIteratorType.FROM_START -> {
                currentShards = this.shardTree.getRoots();
                yield ShardIteratorType.TRIM_HORIZON;
            }
            default -> {
                currentShards = this.shardTree.getLeaves();
                yield ShardIteratorType.LATEST;
            }
        };
        HashMap<String, String> shardIterators = new HashMap<String, String>();
        for (Shard currentShard : currentShards) {
            String shardIterator = this.getShardIterator(currentShard.shardId(), shardIteratorType);
            shardIterators.put(currentShard.shardId(), shardIterator);
        }
        return shardIterators;
    }

    private String getShardIterator(String shardId, ShardIteratorType shardIteratorType) {
        return this.getShardIterator(shardId, shardIteratorType, null);
    }

    private String getShardIterator(String shardId, ShardIteratorType shardIteratorType, String lastSeenSequenceNumber) {
        GetShardIteratorRequest request = (GetShardIteratorRequest)GetShardIteratorRequest.builder().streamArn(this.streamArn).shardId(shardId).shardIteratorType(shardIteratorType).sequenceNumber(lastSeenSequenceNumber).build();
        return this.getClient().getShardIterator(request).shardIterator();
    }

    private DynamoDbStreamsClient getClient() {
        return this.getEndpoint().getClient();
    }
}

