/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.swf;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactoryFactory;
import com.amazonaws.services.simpleworkflow.flow.worker.GenericWorkflowWorker;
import java.util.Arrays;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.component.aws.swf.CamelWorkflowDefinitionFactoryFactory;
import org.apache.camel.component.aws.swf.SWFConfiguration;
import org.apache.camel.component.aws.swf.SWFEndpoint;
import org.apache.camel.component.aws.swf.SWFWorkflowProducer;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SWFWorkflowConsumer
extends DefaultConsumer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(SWFWorkflowProducer.class);
    private SWFEndpoint endpoint;
    private final SWFConfiguration configuration;
    private GenericWorkflowWorker genericWorker;
    private transient String swfWorkflowConsumerToString;

    public SWFWorkflowConsumer(SWFEndpoint endpoint, Processor processor, SWFConfiguration configuration) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    public Object processWorkflow(Object[] parameters, long startTime, boolean replaying) throws Exception {
        LOGGER.debug("Processing workflow task: " + Arrays.toString(parameters));
        Exchange exchange = this.endpoint.createExchange(parameters, "CamelSWFActionExecute");
        exchange.getIn().setHeader("CamelSWFWorkflowStartTime", (Object)startTime);
        exchange.getIn().setHeader("CamelSWFWorkflowReplaying", (Object)replaying);
        this.getProcessor().process(exchange);
        return this.endpoint.getResult(exchange);
    }

    public void signalRecieved(Object[] parameters) throws Exception {
        LOGGER.debug("signalRecieved: " + Arrays.toString(parameters));
        Exchange exchange = this.endpoint.createExchange(parameters, "CamelSWFSignalReceivedAction");
        exchange.setPattern(ExchangePattern.InOnly);
        this.getProcessor().process(exchange);
    }

    public Object getWorkflowState(Object parameters) throws Exception {
        LOGGER.debug("getWorkflowState: " + parameters);
        Exchange exchange = this.endpoint.createExchange(parameters, "CamelSWFGetStateAction");
        this.getProcessor().process(exchange);
        return this.endpoint.getResult(exchange);
    }

    protected void doStart() throws Exception {
        CamelWorkflowDefinitionFactoryFactory factoryFactory = new CamelWorkflowDefinitionFactoryFactory(this, this.configuration);
        this.genericWorker = new GenericWorkflowWorker((AmazonSimpleWorkflow)this.endpoint.getSWClient(), this.configuration.getDomainName(), this.configuration.getWorkflowList());
        this.genericWorker.setWorkflowDefinitionFactoryFactory((WorkflowDefinitionFactoryFactory)factoryFactory);
        this.genericWorker.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.genericWorker.setDisableServiceShutdownOnStop(true);
        this.genericWorker.shutdownNow();
        super.doStop();
    }

    public String toString() {
        if (this.swfWorkflowConsumerToString == null) {
            this.swfWorkflowConsumerToString = "SWFWorkflowConsumer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.swfWorkflowConsumerToString;
    }
}

