/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sdb;

import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.services.simpledb.model.SelectResult;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.sdb.AbstractSdbCommand;
import org.apache.camel.component.aws.sdb.SdbConfiguration;

public class SelectCommand
extends AbstractSdbCommand {
    public SelectCommand(AmazonSimpleDB sdbClient, SdbConfiguration configuration, Exchange exchange) {
        super(sdbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        SelectRequest request = new SelectRequest().withSelectExpression(this.determineSelectExpression()).withConsistentRead(this.determineConsistentRead()).withNextToken(this.determineNextToken());
        this.log.trace("Sending request [{}] for exchange [{}]...", (Object)request, (Object)this.exchange);
        SelectResult result = this.sdbClient.select(request);
        this.log.trace("Received result [{}]", (Object)result);
        Message msg = this.getMessageForResponse(this.exchange);
        msg.setHeader("CamelAwsSdbItems", (Object)result.getItems());
        msg.setHeader("CamelAwsSdbNextToken", (Object)result.getNextToken());
    }

    protected String determineSelectExpression() {
        return (String)this.exchange.getIn().getHeader("CamelAwsSdbSelectExpression", String.class);
    }
}

