/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sdb;

import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.model.BatchPutAttributesRequest;
import com.amazonaws.services.simpledb.model.ReplaceableItem;
import java.util.Collection;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.sdb.AbstractSdbCommand;
import org.apache.camel.component.aws.sdb.SdbConfiguration;

public class BatchPutAttributesCommand
extends AbstractSdbCommand {
    public BatchPutAttributesCommand(AmazonSimpleDB sdbClient, SdbConfiguration configuration, Exchange exchange) {
        super(sdbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        BatchPutAttributesRequest request = new BatchPutAttributesRequest().withDomainName(this.determineDomainName()).withItems(this.determineReplaceableItems());
        this.log.trace("Sending request [{}] for exchange [{}]...", (Object)request, (Object)this.exchange);
        this.sdbClient.batchPutAttributes(request);
        this.log.trace("Request sent");
    }

    protected Collection<ReplaceableItem> determineReplaceableItems() {
        return (Collection)this.exchange.getIn().getHeader("CamelAwsSdbReplaceableItems", Collection.class);
    }
}

