/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sdb;

import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.model.UpdateCondition;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.sdb.SdbConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSdbCommand {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected AmazonSimpleDB sdbClient;
    protected SdbConfiguration configuration;
    protected Exchange exchange;

    public AbstractSdbCommand(AmazonSimpleDB sdbClient, SdbConfiguration configuration, Exchange exchange) {
        this.sdbClient = sdbClient;
        this.configuration = configuration;
        this.exchange = exchange;
    }

    public abstract void execute();

    protected Message getMessageForResponse(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            return out;
        }
        return exchange.getIn();
    }

    protected String determineDomainName() {
        String domainName = (String)this.exchange.getIn().getHeader("CamelAwsSdbDomainName", String.class);
        return domainName != null ? domainName : this.configuration.getDomainName();
    }

    protected String determineItemName() {
        String key = (String)this.exchange.getIn().getHeader("CamelAwsSdbItemName", String.class);
        if (key == null) {
            throw new IllegalArgumentException("AWS SDB Item Name header is missing.");
        }
        return key;
    }

    protected Boolean determineConsistentRead() {
        Boolean consistentRead = (Boolean)this.exchange.getIn().getHeader("CamelAwsSdbConsistentRead", Boolean.class);
        if (consistentRead == null) {
            consistentRead = this.configuration.getConsistentRead();
        }
        return consistentRead;
    }

    protected UpdateCondition determineUpdateCondition() {
        return (UpdateCondition)this.exchange.getIn().getHeader("CamelAwsSdbUpdateCondition", UpdateCondition.class);
    }

    protected String determineNextToken() {
        return (String)this.exchange.getIn().getHeader("CamelAwsSdbNextToken", String.class);
    }
}

