/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb;

import com.amazonaws.services.dynamodb.AmazonDynamoDB;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodb.model.Key;
import java.util.Collection;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.ddb.DdbConfiguration;

public abstract class AbstractDdbCommand {
    protected DdbConfiguration configuration;
    protected Exchange exchange;
    protected AmazonDynamoDB ddbClient;

    public AbstractDdbCommand(AmazonDynamoDB ddbClient, DdbConfiguration configuration, Exchange exchange) {
        this.ddbClient = ddbClient;
        this.configuration = configuration;
        this.exchange = exchange;
    }

    public abstract void execute();

    protected Message getMessageForResponse(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            return out;
        }
        return exchange.getIn();
    }

    protected String determineTableName() {
        String tableName = (String)this.exchange.getIn().getHeader("CamelAwsDdbTableName", String.class);
        return tableName != null ? tableName : this.configuration.getTableName();
    }

    protected Map<String, ExpectedAttributeValue> determineUpdateCondition() {
        return (Map)this.exchange.getIn().getHeader("CamelAwsDdbUpdateCondition", Map.class);
    }

    protected Map<String, AttributeValue> determineItem() {
        return (Map)this.exchange.getIn().getHeader("CamelAwsDdbItem", Map.class);
    }

    protected String determineReturnValues() {
        return (String)this.exchange.getIn().getHeader("CamelAwsDdbReturnValues", String.class);
    }

    protected void addAttributesToResult(Map<String, AttributeValue> attributes) {
        Message msg = this.getMessageForResponse(this.exchange);
        msg.setHeader("CamelAwsDdbAttributes", attributes);
    }

    protected void addToResult(String headerKey, Object value) {
        Message msg = this.getMessageForResponse(this.exchange);
        msg.setHeader(headerKey, value);
    }

    protected Key determineKey() {
        return (Key)this.exchange.getIn().getHeader("CamelAwsDdbKey", Key.class);
    }

    protected Collection<String> determineAttributeNames() {
        return (Collection)this.exchange.getIn().getHeader("CamelAwsDdbAttributeNames", Collection.class);
    }

    protected Boolean determineConsistentRead() {
        Boolean consistentRead = (Boolean)this.exchange.getIn().getHeader("CamelAwsDdbConsistentRead", Boolean.class);
        return consistentRead != null ? consistentRead : this.configuration.getConsistentRead();
    }
}

