/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.xray.decorators;

import com.amazonaws.xray.entities.Entity;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.xray.decorators.AbstractSegmentDecorator;

public class MongoDBSegmentDecorator
extends AbstractSegmentDecorator {
    @Override
    public String getComponent() {
        return "mongodb";
    }

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        Map<String, String> queryParameters = MongoDBSegmentDecorator.toQueryParameters(endpoint.getEndpointUri());
        String opName = queryParameters.get("operation");
        return opName != null ? opName : super.getOperationName(exchange, endpoint);
    }

    @Override
    public void pre(Entity segment, Exchange exchange, Endpoint endpoint) {
        super.pre(segment, exchange, endpoint);
        segment.putMetadata("db.type", (Object)this.getComponent());
        Map<String, String> queryParameters = MongoDBSegmentDecorator.toQueryParameters(endpoint.getEndpointUri());
        String database = queryParameters.get("database");
        if (null != database) {
            segment.putMetadata("db.instance", (Object)database);
        }
        segment.putSql("db.statement", (Object)queryParameters.toString());
    }
}

