/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.xray.decorators;

import com.amazonaws.xray.entities.Entity;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.xray.decorators.AbstractSegmentDecorator;

public class JdbcSegmentDecorator
extends AbstractSegmentDecorator {
    @Override
    public String getComponent() {
        return "jdbc";
    }

    @Override
    public void pre(Entity segment, Exchange exchange, Endpoint endpoint) {
        super.pre(segment, exchange, endpoint);
        segment.putMetadata("db.type", (Object)"sql");
        Object body = exchange.getIn().getBody();
        if (body instanceof String) {
            segment.putSql("db.statement", body);
        }
    }
}

