/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.xray.decorators.messaging;

import com.amazonaws.xray.entities.Entity;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.xray.decorators.AbstractSegmentDecorator;

public abstract class AbstractMessagingSegmentDecorator
extends AbstractSegmentDecorator {
    protected static final String MESSAGE_BUS_ID = "message_bus.id";

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        return this.getDestination(exchange, endpoint);
    }

    @Override
    public void pre(Entity segment, Exchange exchange, Endpoint endpoint) {
        super.pre(segment, exchange, endpoint);
        segment.putMetadata("message_bus.destination", (Object)this.getDestination(exchange, endpoint));
        String messageId = this.getMessageId(exchange);
        if (null != messageId) {
            segment.putMetadata(MESSAGE_BUS_ID, (Object)messageId);
        }
    }

    protected String getDestination(Exchange exchange, Endpoint endpoint) {
        return AbstractMessagingSegmentDecorator.stripSchemeAndOptions(endpoint);
    }

    protected String getMessageId(Exchange exchange) {
        return null;
    }
}

