/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sqs;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class SqsEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":queueNameOrArn";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "aws-sqs".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "queueNameOrArn", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(58);
        props.add("queueUrl");
        props.add("initialDelay");
        props.add("proxyPort");
        props.add("protocol");
        props.add("attributeNames");
        props.add("bridgeErrorHandler");
        props.add("greedy");
        props.add("maxMessagesPerPoll");
        props.add("scheduledExecutorService");
        props.add("messageRetentionPeriod");
        props.add("repeatCount");
        props.add("sendEmptyMessageWhenIdle");
        props.add("schedulerProperties");
        props.add("extendMessageVisibility");
        props.add("queueOwnerAWSAccountId");
        props.add("concurrentConsumers");
        props.add("proxyHost");
        props.add("receiveMessageWaitTimeSeconds");
        props.add("backoffIdleThreshold");
        props.add("lazyStartProducer");
        props.add("waitTimeSeconds");
        props.add("delay");
        props.add("redrivePolicy");
        props.add("startScheduler");
        props.add("accessKey");
        props.add("region");
        props.add("exceptionHandler");
        props.add("backoffMultiplier");
        props.add("maximumMessageSize");
        props.add("deleteIfFiltered");
        props.add("messageDeduplicationIdStrategy");
        props.add("kmsDataKeyReusePeriodSeconds");
        props.add("visibilityTimeout");
        props.add("scheduler");
        props.add("useFixedDelay");
        props.add("headerFilterStrategy");
        props.add("runLoggingLevel");
        props.add("backoffErrorThreshold");
        props.add("autoCreateQueue");
        props.add("kmsMasterKeyId");
        props.add("amazonAWSHost");
        props.add("delayQueue");
        props.add("policy");
        props.add("timeUnit");
        props.add("delaySeconds");
        props.add("autoDiscoverClient");
        props.add("messageAttributeNames");
        props.add("serverSideEncryptionEnabled");
        props.add("proxyProtocol");
        props.add("secretKey");
        props.add("queueNameOrArn");
        props.add("exchangePattern");
        props.add("defaultVisibilityTimeout");
        props.add("messageGroupIdStrategy");
        props.add("pollStrategy");
        props.add("amazonSQSClient");
        props.add("deleteAfterRead");
        props.add("operation");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(3);
        secretProps.add("secretKey");
        secretProps.add("accessKey");
        secretProps.add("queueOwnerAWSAccountId");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

