/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.secretsmanager;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws.secretsmanager.SecretsManagerPropertiesFunction;
import org.apache.camel.component.aws.secretsmanager.vault.CloudTrailReloadTriggerTask;
import org.apache.camel.spi.PeriodTaskScheduler;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.vault.AwsVaultConfiguration;

@DevConsole(value="aws-secrets")
public class SecretsDevConsole
extends AbstractDevConsole {
    private SecretsManagerPropertiesFunction propertiesFunction;
    private CloudTrailReloadTriggerTask secretsRefreshTask;

    public SecretsDevConsole() {
        super("camel", "aws-secrets", "AWS Secrets", "AWS Secrets Manager");
    }

    protected void doStart() throws Exception {
        AwsVaultConfiguration aws;
        PropertiesFunction pf;
        super.doStart();
        if (this.getCamelContext().getPropertiesComponent().hasPropertiesFunction("aws") && (pf = this.getCamelContext().getPropertiesComponent().getPropertiesFunction("aws")) instanceof SecretsManagerPropertiesFunction) {
            this.propertiesFunction = (SecretsManagerPropertiesFunction)pf;
        }
        if ((aws = this.getCamelContext().getVaultConfiguration().getAwsVaultConfiguration()) != null && aws.isRefreshEnabled()) {
            PeriodTaskScheduler scheduler = PluginHelper.getPeriodTaskScheduler((CamelContext)this.getCamelContext());
            this.secretsRefreshTask = (CloudTrailReloadTriggerTask)scheduler.getTaskByType(CloudTrailReloadTriggerTask.class);
        }
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        if (this.propertiesFunction != null) {
            sb.append("AWS Secrets Manager:");
            sb.append(String.format("\n    Region: %s", this.propertiesFunction.getRegion()));
            if (this.propertiesFunction.isDefaultCredentialsProvider()) {
                sb.append("\n    Login: DefaultCredentialsProvider");
            } else if (this.propertiesFunction.isProfleCredentialsProvider()) {
                sb.append("\n    Login: ProfileCredentialsProvider");
            } else {
                sb.append("\n    Login: Access and Secret Keys");
            }
            AwsVaultConfiguration aws = this.getCamelContext().getVaultConfiguration().getAwsVaultConfiguration();
            if (aws != null) {
                sb.append(String.format("\n    Refresh Enabled: %s", aws.isRefreshEnabled()));
                sb.append(String.format("\n    Refresh Period: %s", aws.getRefreshPeriod()));
            }
            if (this.secretsRefreshTask != null) {
                Instant last = this.secretsRefreshTask.getLastCheckTime();
                String s = last != null ? TimeUtils.printSince((long)last.toEpochMilli()) : "none";
                sb.append(String.format("\n    Last Check: %s", s));
                last = this.secretsRefreshTask.getLastReloadTime();
                s = last != null ? TimeUtils.printSince((long)last.toEpochMilli()) : "none";
                sb.append(String.format("\n    Last Reload: %s", s));
            }
            sb.append("\n\nSecrets in use:");
            ArrayList<String> sorted = new ArrayList<String>(this.propertiesFunction.getSecrets());
            Collections.sort(sorted);
            for (String sec : sorted) {
                String age;
                Instant last = this.secretsRefreshTask != null ? this.secretsRefreshTask.getUpdates().get(sec) : null;
                String string = age = last != null ? TimeUtils.printSince((long)last.toEpochMilli()) : null;
                if (age != null) {
                    sb.append(String.format("\n    %s (age: %s)", sec, age));
                    continue;
                }
                sb.append(String.format("\n    %s", sec));
            }
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        if (this.propertiesFunction != null) {
            root.put((Object)"region", (Object)this.propertiesFunction.getRegion());
            if (this.propertiesFunction.isDefaultCredentialsProvider()) {
                root.put((Object)"login", (Object)"DefaultCredentialsProvider");
            } else if (this.propertiesFunction.isProfleCredentialsProvider()) {
                root.put((Object)"login", (Object)"ProfileCredentialsProvider");
            } else {
                root.put((Object)"login", (Object)"Access and Secret Keys");
            }
            AwsVaultConfiguration aws = this.getCamelContext().getVaultConfiguration().getAwsVaultConfiguration();
            if (aws != null) {
                root.put((Object)"refreshEnabled", (Object)aws.isRefreshEnabled());
                root.put((Object)"refreshPeriod", (Object)aws.getRefreshPeriod());
            }
            if (this.secretsRefreshTask != null) {
                long timestamp;
                Instant last = this.secretsRefreshTask.getLastCheckTime();
                if (last != null) {
                    timestamp = last.toEpochMilli();
                    root.put((Object)"lastCheckTimestamp", (Object)timestamp);
                    root.put((Object)"lastCheckAge", (Object)TimeUtils.printSince((long)timestamp));
                }
                if ((last = this.secretsRefreshTask.getLastReloadTime()) != null) {
                    timestamp = last.toEpochMilli();
                    root.put((Object)"lastReloadTimestamp", (Object)timestamp);
                    root.put((Object)"lastReloadAge", (Object)TimeUtils.printSince((long)timestamp));
                }
            }
            JsonArray arr = new JsonArray();
            root.put((Object)"secrets", (Object)arr);
            ArrayList<String> sorted = new ArrayList<String>(this.propertiesFunction.getSecrets());
            Collections.sort(sorted);
            for (String sec : sorted) {
                Instant last;
                JsonObject jo = new JsonObject();
                jo.put((Object)"name", (Object)sec);
                Instant instant = last = this.secretsRefreshTask != null ? this.secretsRefreshTask.getUpdates().get(sec) : null;
                if (last != null) {
                    long timestamp = last.toEpochMilli();
                    jo.put((Object)"timestamp", (Object)timestamp);
                    jo.put((Object)"age", (Object)TimeUtils.printSince((long)timestamp));
                }
                arr.add((Object)jo);
            }
        }
        return root;
    }
}

