/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.secretsmanager.vault;

import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.aws.secretsmanager.SecretsManagerPropertiesFunction;
import org.apache.camel.spi.ContextReloadStrategy;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.spi.annotations.PeriodicTask;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.vault.AwsVaultConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClientBuilder;
import software.amazon.awssdk.services.cloudtrail.model.Event;
import software.amazon.awssdk.services.cloudtrail.model.LookupAttribute;
import software.amazon.awssdk.services.cloudtrail.model.LookupAttributeKey;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse;
import software.amazon.awssdk.services.cloudtrail.model.Resource;

@PeriodicTask(value="aws-secret-refresh")
public class CloudTrailReloadTriggerTask
extends ServiceSupport
implements CamelContextAware,
Runnable {
    private static final String CAMEL_AWS_VAULT_ACCESS_KEY_ENV = "CAMEL_VAULT_AWS_ACCESS_KEY";
    private static final String CAMEL_AWS_VAULT_SECRET_KEY_ENV = "CAMEL_VAULT_AWS_SECRET_KEY";
    private static final String CAMEL_AWS_VAULT_REGION_ENV = "CAMEL_VAULT_AWS_REGION";
    private static final String CAMEL_AWS_VAULT_USE_DEFAULT_CREDENTIALS_PROVIDER_ENV = "CAMEL_VAULT_AWS_USE_DEFAULT_CREDENTIALS_PROVIDER";
    private static final Logger LOG = LoggerFactory.getLogger(CloudTrailReloadTriggerTask.class);
    private static final String SECRETSMANAGER_AMAZONAWS_COM = "secretsmanager.amazonaws.com";
    private CamelContext camelContext;
    private boolean reloadEnabled = true;
    private String secrets;
    private CloudTrailClient cloudTrailClient;
    private SecretsManagerPropertiesFunction propertiesFunction;
    private volatile Instant lastTime;
    private volatile Instant lastCheckTime;
    private volatile Instant lastReloadTime;
    private final Map<String, Instant> updates = new HashMap<String, Instant>();

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isReloadEnabled() {
        return this.reloadEnabled;
    }

    public void setReloadEnabled(boolean reloadEnabled) {
        this.reloadEnabled = reloadEnabled;
    }

    public Map<String, Instant> getUpdates() {
        return Collections.unmodifiableMap(this.updates);
    }

    public Instant getLastCheckTime() {
        return this.lastCheckTime;
    }

    public Instant getLastReloadTime() {
        return this.lastReloadTime;
    }

    protected void doStart() throws Exception {
        CloudTrailClientBuilder clientBuilder;
        AwsVaultConfiguration awsVaultConfiguration;
        super.doStart();
        PropertiesComponent pc = this.camelContext.getPropertiesComponent();
        PropertiesFunction pf = pc.getPropertiesFunction("aws");
        if (pf instanceof SecretsManagerPropertiesFunction) {
            this.propertiesFunction = (SecretsManagerPropertiesFunction)pf;
            LOG.debug("Auto-detecting secrets from properties-function: {}", (Object)pf.getName());
        }
        this.secrets = this.camelContext.getVaultConfiguration().aws().getSecrets();
        if (ObjectHelper.isEmpty((String)this.secrets) && this.propertiesFunction == null) {
            throw new IllegalArgumentException("Secrets must be configured on AWS vault configuration");
        }
        String accessKey = System.getenv(CAMEL_AWS_VAULT_ACCESS_KEY_ENV);
        String secretKey = System.getenv(CAMEL_AWS_VAULT_SECRET_KEY_ENV);
        String region = System.getenv(CAMEL_AWS_VAULT_REGION_ENV);
        boolean useDefaultCredentialsProvider = Boolean.parseBoolean(System.getenv(CAMEL_AWS_VAULT_USE_DEFAULT_CREDENTIALS_PROVIDER_ENV));
        if (ObjectHelper.isEmpty((String)accessKey) && ObjectHelper.isEmpty((String)secretKey) && ObjectHelper.isEmpty((String)region) && ObjectHelper.isNotEmpty((Object)(awsVaultConfiguration = this.getCamelContext().getVaultConfiguration().aws()))) {
            accessKey = awsVaultConfiguration.getAccessKey();
            secretKey = awsVaultConfiguration.getSecretKey();
            region = awsVaultConfiguration.getRegion();
            useDefaultCredentialsProvider = awsVaultConfiguration.isDefaultCredentialsProvider();
        }
        if (ObjectHelper.isNotEmpty((String)accessKey) && ObjectHelper.isNotEmpty((String)secretKey) && ObjectHelper.isNotEmpty((String)region)) {
            clientBuilder = CloudTrailClient.builder();
            AwsBasicCredentials cred = AwsBasicCredentials.create((String)accessKey, (String)secretKey);
            clientBuilder = (CloudTrailClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
            clientBuilder.region(Region.of((String)region));
            this.cloudTrailClient = (CloudTrailClient)clientBuilder.build();
        } else if (useDefaultCredentialsProvider && ObjectHelper.isNotEmpty((String)region)) {
            clientBuilder = CloudTrailClient.builder();
            clientBuilder.region(Region.of((String)region));
            this.cloudTrailClient = (CloudTrailClient)clientBuilder.build();
        } else {
            throw new RuntimeCamelException("Using the AWS Secrets Refresh Task requires setting AWS credentials as application properties or environment variables");
        }
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.cloudTrailClient != null) {
            try {
                this.cloudTrailClient.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cloudTrailClient = null;
        }
        this.updates.clear();
    }

    @Override
    public void run() {
        ContextReloadStrategy reload;
        this.lastCheckTime = Instant.now();
        boolean triggerReloading = false;
        try {
            LookupEventsRequest lookupEventsRequest;
            LookupEventsResponse response;
            List events;
            LookupEventsRequest.Builder eventsRequestBuilder = LookupEventsRequest.builder().maxResults(Integer.valueOf(100)).lookupAttributes(new LookupAttribute[]{(LookupAttribute)LookupAttribute.builder().attributeKey(LookupAttributeKey.EVENT_SOURCE).attributeValue(SECRETSMANAGER_AMAZONAWS_COM).build()});
            if (this.lastTime != null) {
                eventsRequestBuilder.startTime(this.lastTime.plusMillis(1000L));
            }
            if (!(events = (response = this.cloudTrailClient.lookupEvents(lookupEventsRequest = (LookupEventsRequest)eventsRequestBuilder.build())).events()).isEmpty()) {
                this.lastTime = ((Event)events.get(0)).eventTime();
            }
            LOG.debug("Found {} events", (Object)events.size());
            block2: for (Event event : events) {
                if (!event.eventSource().equalsIgnoreCase(SECRETSMANAGER_AMAZONAWS_COM) || !event.eventName().equalsIgnoreCase("PutSecretValue")) continue;
                List a = event.resources();
                for (Resource res : a) {
                    String name = res.resourceName();
                    if (!this.matchSecret(name)) continue;
                    this.updates.put(name, event.eventTime());
                    if (!this.isReloadEnabled()) continue block2;
                    LOG.info("Update for AWS secret: {} detected, triggering CamelContext reload", (Object)name);
                    triggerReloading = true;
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error during AWS Secrets Refresh Task due to " + e.getMessage() + ". This exception is ignored. Will try again on next run.", (Throwable)e);
        }
        if (triggerReloading && (reload = (ContextReloadStrategy)this.camelContext.hasService(ContextReloadStrategy.class)) != null) {
            this.lastReloadTime = Instant.now();
            reload.onReload((Object)this);
        }
    }

    protected boolean matchSecret(String name) {
        HashSet<String> set = new HashSet<String>();
        if (this.secrets != null) {
            Collections.addAll(set, this.secrets.split(","));
        }
        if (this.propertiesFunction != null) {
            set.addAll(this.propertiesFunction.getSecrets());
        }
        for (String part : set) {
            boolean result = name.contains(part) || PatternHelper.matchPattern((String)name, (String)part);
            LOG.trace("Matching secret id: {}={} -> {}", new Object[]{name, part, result});
            if (!result) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "AWS Secrets Refresh Task";
    }
}

