/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.s3;

import com.amazonaws.Protocol;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.aws.s3.S3Endpoint;
import org.apache.camel.component.aws.s3.S3Operations;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class S3EndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return S3EndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return S3EndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "amazonS3Client": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setAmazonS3Client((AmazonS3)S3EndpointConfigurer.property((CamelContext)camelContext, AmazonS3.class, (Object)value));
                return true;
            }
            case "accessKey": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretKey": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "fileName": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setFileName((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "prefix": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setPrefix((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "delimiter": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setDelimiter((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "region": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setRegion((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "deleteAfterRead": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setDeleteAfterRead((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "deleteAfterWrite": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setDeleteAfterWrite((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "multiPartUpload": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setMultiPartUpload((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "partSize": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setPartSize((Long)S3EndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "policy": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setPolicy((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "storageClass": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setStorageClass((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serverSideEncryption": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setServerSideEncryption((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyProtocol": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setProxyProtocol((Protocol)S3EndpointConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "proxyHost": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyPort": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)S3EndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "includeBody": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setIncludeBody((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pathStyleAccess": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setPathStyleAccess((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setOperation((S3Operations)((Object)S3EndpointConfigurer.property((CamelContext)camelContext, S3Operations.class, (Object)value)));
                return true;
            }
            case "autocloseBody": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setAutocloseBody((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "encryptionMaterials": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setEncryptionMaterials((EncryptionMaterials)S3EndpointConfigurer.property((CamelContext)camelContext, EncryptionMaterials.class, (Object)value));
                return true;
            }
            case "useEncryption": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setUseEncryption((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "chunkedEncodingDisabled": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setChunkedEncodingDisabled((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "accelerateModeEnabled": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setAccelerateModeEnabled((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "dualstackEnabled": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setDualstackEnabled((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "payloadSigningEnabled": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setPayloadSigningEnabled((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "forceGlobalBucketAccessEnabled": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setForceGlobalBucketAccessEnabled((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autoCreateBucket": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setAutoCreateBucket((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "useAwsKMS": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setUseAwsKMS((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "awsKMSKeyId": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setAwsKMSKeyId((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "useIAMCredentials": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setUseIAMCredentials((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "keyName": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setKeyName((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "maxMessagesPerPoll": {
                ((S3Endpoint)((Object)endpoint)).setMaxMessagesPerPoll((Integer)S3EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxConnections": {
                ((S3Endpoint)((Object)endpoint)).setMaxConnections((Integer)S3EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "startScheduler": {
                ((S3Endpoint)((Object)endpoint)).setStartScheduler((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialDelay": {
                ((S3Endpoint)((Object)endpoint)).setInitialDelay((Long)S3EndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((S3Endpoint)((Object)endpoint)).setDelay((Long)S3EndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeUnit": {
                ((S3Endpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)S3EndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "useFixedDelay": {
                ((S3Endpoint)((Object)endpoint)).setUseFixedDelay((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollStrategy": {
                ((S3Endpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)S3EndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runLoggingLevel": {
                ((S3Endpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)S3EndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendEmptyMessageWhenIdle": {
                ((S3Endpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((S3Endpoint)((Object)endpoint)).setGreedy((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((S3Endpoint)((Object)endpoint)).setScheduler((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerProperties": {
                ((S3Endpoint)((Object)endpoint)).setSchedulerProperties((Map)S3EndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledExecutorService": {
                ((S3Endpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)S3EndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffMultiplier": {
                ((S3Endpoint)((Object)endpoint)).setBackoffMultiplier((Integer)S3EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffIdleThreshold": {
                ((S3Endpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)S3EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffErrorThreshold": {
                ((S3Endpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)S3EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "repeatCount": {
                ((S3Endpoint)((Object)endpoint)).setRepeatCount((Long)S3EndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((S3Endpoint)((Object)endpoint)).setLazyStartProducer((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((S3Endpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((S3Endpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)S3EndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((S3Endpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)S3EndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((S3Endpoint)((Object)endpoint)).setSynchronous((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((S3Endpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "amazons3client": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setAmazonS3Client((AmazonS3)S3EndpointConfigurer.property((CamelContext)camelContext, AmazonS3.class, (Object)value));
                return true;
            }
            case "accesskey": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "filename": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setFileName((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "prefix": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setPrefix((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "delimiter": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setDelimiter((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "region": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setRegion((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "deleteafterread": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setDeleteAfterRead((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "deleteafterwrite": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setDeleteAfterWrite((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "multipartupload": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setMultiPartUpload((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "partsize": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setPartSize((Long)S3EndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "policy": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setPolicy((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "storageclass": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setStorageClass((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serversideencryption": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setServerSideEncryption((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyprotocol": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setProxyProtocol((Protocol)S3EndpointConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "proxyhost": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)S3EndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "includebody": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setIncludeBody((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pathstyleaccess": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setPathStyleAccess((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setOperation((S3Operations)((Object)S3EndpointConfigurer.property((CamelContext)camelContext, S3Operations.class, (Object)value)));
                return true;
            }
            case "autoclosebody": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setAutocloseBody((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "encryptionmaterials": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setEncryptionMaterials((EncryptionMaterials)S3EndpointConfigurer.property((CamelContext)camelContext, EncryptionMaterials.class, (Object)value));
                return true;
            }
            case "useencryption": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setUseEncryption((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "chunkedencodingdisabled": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setChunkedEncodingDisabled((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "acceleratemodeenabled": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setAccelerateModeEnabled((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "dualstackenabled": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setDualstackEnabled((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "payloadsigningenabled": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setPayloadSigningEnabled((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "forceglobalbucketaccessenabled": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setForceGlobalBucketAccessEnabled((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autocreatebucket": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setAutoCreateBucket((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "useawskms": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setUseAwsKMS((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "awskmskeyid": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setAwsKMSKeyId((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "useiamcredentials": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setUseIAMCredentials((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "keyname": {
                ((S3Endpoint)((Object)endpoint)).getConfiguration().setKeyName((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "maxmessagesperpoll": {
                ((S3Endpoint)((Object)endpoint)).setMaxMessagesPerPoll((Integer)S3EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxconnections": {
                ((S3Endpoint)((Object)endpoint)).setMaxConnections((Integer)S3EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "startscheduler": {
                ((S3Endpoint)((Object)endpoint)).setStartScheduler((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialdelay": {
                ((S3Endpoint)((Object)endpoint)).setInitialDelay((Long)S3EndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((S3Endpoint)((Object)endpoint)).setDelay((Long)S3EndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeunit": {
                ((S3Endpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)S3EndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "usefixeddelay": {
                ((S3Endpoint)((Object)endpoint)).setUseFixedDelay((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollstrategy": {
                ((S3Endpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)S3EndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runlogginglevel": {
                ((S3Endpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)S3EndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": {
                ((S3Endpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((S3Endpoint)((Object)endpoint)).setGreedy((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((S3Endpoint)((Object)endpoint)).setScheduler((String)S3EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerproperties": {
                ((S3Endpoint)((Object)endpoint)).setSchedulerProperties((Map)S3EndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": {
                ((S3Endpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)S3EndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffmultiplier": {
                ((S3Endpoint)((Object)endpoint)).setBackoffMultiplier((Integer)S3EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": {
                ((S3Endpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)S3EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backofferrorthreshold": {
                ((S3Endpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)S3EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "repeatcount": {
                ((S3Endpoint)((Object)endpoint)).setRepeatCount((Long)S3EndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((S3Endpoint)((Object)endpoint)).setLazyStartProducer((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((S3Endpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((S3Endpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)S3EndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((S3Endpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)S3EndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((S3Endpoint)((Object)endpoint)).setSynchronous((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((S3Endpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)S3EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

