/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.config;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws.config.AWSConfigConfiguration;
import org.apache.camel.component.aws.config.AWSConfigEndpoint;
import org.apache.camel.component.aws.config.AWSConfigOperations;
import org.apache.camel.component.aws.config.AWSConfigProducerHealthCheck;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.WritableHealthCheckRepository;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.model.ConfigRule;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteConformancePackRequest;
import software.amazon.awssdk.services.config.model.DeleteConformancePackResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutConformancePackRequest;
import software.amazon.awssdk.services.config.model.PutConformancePackResponse;
import software.amazon.awssdk.services.config.model.Source;

public class AWSConfigProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AWSConfigProducer.class);
    private transient String configProducerToString;
    private HealthCheck producerHealthCheck;
    private WritableHealthCheckRepository healthCheckRepository;

    public AWSConfigProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case putConfigRule: {
                this.putConfigRule(this.getEndpoint().getConfigClient(), exchange);
                break;
            }
            case removeConfigRule: {
                this.removeConfigRule(this.getEndpoint().getConfigClient(), exchange);
                break;
            }
            case describeRuleCompliance: {
                this.describeRuleCompliance(this.getEndpoint().getConfigClient(), exchange);
                break;
            }
            case putConformancePack: {
                this.putConformancePack(this.getEndpoint().getConfigClient(), exchange);
                break;
            }
            case removeConformancePack: {
                this.removeConformancePack(this.getEndpoint().getConfigClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private AWSConfigOperations determineOperation(Exchange exchange) {
        AWSConfigOperations operation = (AWSConfigOperations)((Object)exchange.getIn().getHeader("CamelAwsConfigOperation", AWSConfigOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected AWSConfigConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.configProducerToString == null) {
            this.configProducerToString = "AWSConfigProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.configProducerToString;
    }

    public AWSConfigEndpoint getEndpoint() {
        return (AWSConfigEndpoint)super.getEndpoint();
    }

    private void putConfigRule(ConfigClient configClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof PutConfigRuleRequest) {
                PutConfigRuleResponse result;
                try {
                    PutConfigRuleRequest request = (PutConfigRuleRequest)payload;
                    result = configClient.putConfigRule(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Put Config rule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = AWSConfigProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            PutConfigRuleResponse result;
            PutConfigRuleRequest.Builder builder = PutConfigRuleRequest.builder();
            ConfigRule.Builder configRule = ConfigRule.builder();
            Source.Builder source = Source.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsConfigRuleSource"))) {
                throw new IllegalArgumentException("Source Owner must be specified");
            }
            String sourceString = (String)exchange.getIn().getHeader("CamelAwsConfigRuleSource", String.class);
            source.owner(sourceString);
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsConfigRuleSourceIdentifier"))) {
                String ruleId = (String)exchange.getIn().getHeader("CamelAwsConfigRuleSourceIdentifier", String.class);
                source.sourceIdentifier(ruleId);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsConfigRuleName"))) {
                String ruleName = (String)exchange.getIn().getHeader("CamelAwsConfigRuleName", String.class);
                configRule.configRuleName(ruleName);
            }
            configRule.source((Source)source.build());
            try {
                PutConfigRuleRequest request = (PutConfigRuleRequest)builder.configRule((ConfigRule)configRule.build()).build();
                result = configClient.putConfigRule(request);
            }
            catch (AwsServiceException ase) {
                LOG.trace("Put Config Rule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = AWSConfigProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void removeConfigRule(ConfigClient configClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteConfigRuleRequest) {
                DeleteConfigRuleResponse result;
                try {
                    DeleteConfigRuleRequest request = (DeleteConfigRuleRequest)payload;
                    result = configClient.deleteConfigRule(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Delete Config rule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = AWSConfigProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DeleteConfigRuleResponse result;
            DeleteConfigRuleRequest.Builder builder = DeleteConfigRuleRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsConfigRuleName"))) {
                throw new IllegalArgumentException("Rule Name must be specified");
            }
            String ruleName = (String)exchange.getIn().getHeader("CamelAwsConfigRuleName", String.class);
            builder.configRuleName(ruleName);
            try {
                DeleteConfigRuleRequest request = (DeleteConfigRuleRequest)builder.build();
                result = configClient.deleteConfigRule(request);
            }
            catch (AwsServiceException ase) {
                LOG.trace("Delete Config Rule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = AWSConfigProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void describeRuleCompliance(ConfigClient configClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DescribeComplianceByConfigRuleRequest) {
                DescribeComplianceByConfigRuleResponse result;
                try {
                    DescribeComplianceByConfigRuleRequest request = (DescribeComplianceByConfigRuleRequest)payload;
                    result = configClient.describeComplianceByConfigRule(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Describe Compliance by Config rule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = AWSConfigProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DescribeComplianceByConfigRuleResponse result;
            DescribeComplianceByConfigRuleRequest.Builder builder = DescribeComplianceByConfigRuleRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsConfigRuleName"))) {
                String ruleName = (String)exchange.getIn().getHeader("CamelAwsConfigRuleName", String.class);
                builder.configRuleNames(new String[]{ruleName});
            }
            try {
                DescribeComplianceByConfigRuleRequest request = (DescribeComplianceByConfigRuleRequest)builder.build();
                result = configClient.describeComplianceByConfigRule(request);
            }
            catch (AwsServiceException ase) {
                LOG.trace("Describe Compliance by Config Rule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = AWSConfigProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void putConformancePack(ConfigClient configClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof PutConformancePackRequest) {
                PutConformancePackResponse result;
                try {
                    PutConformancePackRequest request = (PutConformancePackRequest)payload;
                    result = configClient.putConformancePack(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Put Conformance Pack command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = AWSConfigProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            PutConformancePackResponse result;
            PutConformancePackRequest.Builder builder = PutConformancePackRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsConformancePackName"))) {
                throw new IllegalArgumentException("Rule Name must be specified");
            }
            String conformancePackName = (String)exchange.getIn().getHeader("CamelAwsConformancePackName", String.class);
            builder.conformancePackName(conformancePackName);
            String conformancePackS3TemplateUri = null;
            String conformancePackTemplateBody = null;
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsConfigConformacePackS3TemplateURI"))) {
                conformancePackS3TemplateUri = (String)exchange.getIn().getHeader("CamelAwsConfigConformacePackS3TemplateURI", String.class);
                builder.templateS3Uri(conformancePackS3TemplateUri);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsConfigConformacePackTemplateBody"))) {
                conformancePackTemplateBody = (String)exchange.getIn().getHeader("CamelAwsConfigConformacePackTemplateBody", String.class);
                builder.templateBody(conformancePackTemplateBody);
            }
            if (ObjectHelper.isEmpty((String)conformancePackS3TemplateUri) && ObjectHelper.isEmpty(conformancePackTemplateBody)) {
                throw new IllegalArgumentException("One of Conformace Pack S3 Template URI or Template Body must be specified");
            }
            try {
                PutConformancePackRequest request = (PutConformancePackRequest)builder.build();
                result = configClient.putConformancePack(request);
            }
            catch (AwsServiceException ase) {
                LOG.trace("Put Conformance Pack command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = AWSConfigProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void removeConformancePack(ConfigClient configClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DeleteConformancePackRequest) {
                DeleteConformancePackResponse result;
                try {
                    DeleteConformancePackRequest request = (DeleteConformancePackRequest)payload;
                    result = configClient.deleteConformancePack(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Remove Conformance Pack rule command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = AWSConfigProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DeleteConformancePackResponse result;
            DeleteConformancePackRequest.Builder builder = DeleteConformancePackRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsConformancePackName"))) {
                throw new IllegalArgumentException("Conformance Pack Name must be specified");
            }
            String conformancePackName = (String)exchange.getIn().getHeader("CamelAwsConfigRuleName", String.class);
            builder.conformancePackName(conformancePackName);
            try {
                DeleteConformancePackRequest request = (DeleteConformancePackRequest)builder.build();
                result = configClient.deleteConformancePack(request);
            }
            catch (AwsServiceException ase) {
                LOG.trace("Remove Conformance Pack command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = AWSConfigProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    protected void doStart() throws Exception {
        this.healthCheckRepository = (WritableHealthCheckRepository)HealthCheckHelper.getHealthCheckRepository((CamelContext)this.getEndpoint().getCamelContext(), (String)"producers", WritableHealthCheckRepository.class);
        if (this.healthCheckRepository != null) {
            String id = this.getEndpoint().getId();
            this.producerHealthCheck = new AWSConfigProducerHealthCheck(this.getEndpoint(), id);
            this.producerHealthCheck.setEnabled(this.getEndpoint().getComponent().isHealthCheckProducerEnabled());
            this.healthCheckRepository.addHealthCheck(this.producerHealthCheck);
        }
    }

    protected void doStop() throws Exception {
        if (this.healthCheckRepository != null && this.producerHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck(this.producerHealthCheck);
            this.producerHealthCheck = null;
        }
    }
}

