/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.config;

import java.util.Map;
import org.apache.camel.component.aws.config.AWSConfigConfiguration;
import org.apache.camel.component.aws.config.AWSConfigEndpoint;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest;

public class AWSConfigProducerHealthCheck
extends AbstractHealthCheck {
    private final AWSConfigEndpoint configEndpoint;

    public AWSConfigProducerHealthCheck(AWSConfigEndpoint configEndpoint, String clientId) {
        super("camel", "producer:aws-config-" + clientId);
        this.configEndpoint = configEndpoint;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        AWSConfigConfiguration configuration = this.configEndpoint.getConfiguration();
        if (ObjectHelper.isNotEmpty((String)configuration.getRegion()) && !ConfigClient.serviceMetadata().regions().contains(Region.of((String)configuration.getRegion()))) {
            builder.message("The service is not supported in this region");
            builder.down();
            return;
        }
        try {
            ConfigClient configClient = this.configEndpoint.getConfigClient();
            configClient.listDiscoveredResources((ListDiscoveredResourcesRequest)ListDiscoveredResourcesRequest.builder().build());
        }
        catch (AwsServiceException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            if (ObjectHelper.isNotEmpty((Object)e.statusCode())) {
                builder.detail("service.status.code", (Object)e.statusCode());
            }
            if (ObjectHelper.isNotEmpty((String)e.awsErrorDetails().errorCode())) {
                builder.detail("service.error.code", (Object)e.awsErrorDetails().errorCode());
            }
            builder.down();
            return;
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

