/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.runtime.stream;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.camel.component.aws2.bedrock.runtime.stream.StreamResponseParser;

public class ClaudeStreamParser
implements StreamResponseParser {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public String extractText(String chunk) throws JsonProcessingException {
        JsonNode deltaType;
        JsonNode delta;
        if (chunk == null || chunk.trim().isEmpty()) {
            return "";
        }
        JsonNode node = MAPPER.readTree(chunk);
        JsonNode type = node.get("type");
        if (type != null && "content_block_delta".equals(type.asText()) && (delta = node.get("delta")) != null && (deltaType = delta.get("type")) != null && "text_delta".equals(deltaType.asText())) {
            JsonNode text = delta.get("text");
            return text != null && !text.isNull() ? text.asText() : "";
        }
        return "";
    }

    @Override
    public String extractCompletionReason(String chunk) throws JsonProcessingException {
        JsonNode delta;
        if (chunk == null || chunk.trim().isEmpty()) {
            return null;
        }
        JsonNode node = MAPPER.readTree(chunk);
        JsonNode type = node.get("type");
        if (type != null && "message_delta".equals(type.asText()) && (delta = node.get("delta")) != null) {
            JsonNode stopReason = delta.get("stop_reason");
            return stopReason != null && !stopReason.isNull() ? stopReason.asText() : null;
        }
        return null;
    }

    @Override
    public Integer extractTokenCount(String chunk) throws JsonProcessingException {
        JsonNode usage;
        if (chunk == null || chunk.trim().isEmpty()) {
            return null;
        }
        JsonNode node = MAPPER.readTree(chunk);
        JsonNode type = node.get("type");
        if (type != null && "message_delta".equals(type.asText()) && (usage = node.get("usage")) != null) {
            JsonNode outputTokens = usage.get("output_tokens");
            return outputTokens != null && !outputTokens.isNull() ? Integer.valueOf(outputTokens.asInt()) : null;
        }
        return null;
    }

    @Override
    public boolean isFinalChunk(String chunk) throws JsonProcessingException {
        if (chunk == null || chunk.trim().isEmpty()) {
            return false;
        }
        JsonNode node = MAPPER.readTree(chunk);
        JsonNode type = node.get("type");
        return type != null && "message_stop".equals(type.asText());
    }
}

