/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.runtime.stream;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.function.Consumer;
import org.apache.camel.component.aws2.bedrock.runtime.stream.StreamParserFactory;
import org.apache.camel.component.aws2.bedrock.runtime.stream.StreamResponseParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithResponseStreamResponseHandler;

public final class BedrockStreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BedrockStreamHandler.class);

    private BedrockStreamHandler() {
    }

    public static InvokeModelWithResponseStreamResponseHandler createCompleteHandler(String modelId, StreamMetadata metadata, StringBuilder fullText) {
        StreamResponseParser parser = StreamParserFactory.getParser(modelId);
        int[] chunkCount = new int[]{0};
        return ((InvokeModelWithResponseStreamResponseHandler.Builder)InvokeModelWithResponseStreamResponseHandler.builder().subscriber(InvokeModelWithResponseStreamResponseHandler.Visitor.builder().onChunk(part -> {
            try {
                String chunkJson = part.bytes().asUtf8String();
                String text = parser.extractText(chunkJson);
                if (text != null && !text.isEmpty()) {
                    fullText.append(text);
                }
                if (parser.isFinalChunk(chunkJson)) {
                    Integer tokenCount;
                    String completionReason = parser.extractCompletionReason(chunkJson);
                    if (completionReason != null) {
                        metadata.setCompletionReason(completionReason);
                    }
                    if ((tokenCount = parser.extractTokenCount(chunkJson)) != null) {
                        metadata.setTokenCount(tokenCount);
                    }
                }
                chunkCount[0] = chunkCount[0] + 1;
            }
            catch (JsonProcessingException e) {
                LOG.warn("Error parsing streaming chunk: {}", (Object)e.getMessage(), (Object)e);
            }
        }).build()).onComplete(() -> {
            metadata.setChunkCount(chunkCount[0]);
            metadata.setFullText(fullText.toString());
        })).build();
    }

    public static InvokeModelWithResponseStreamResponseHandler createChunksHandler(String modelId, StreamMetadata metadata, List<String> chunks, Consumer<String> chunkConsumer) {
        StreamResponseParser parser = StreamParserFactory.getParser(modelId);
        int[] chunkCount = new int[]{0};
        return ((InvokeModelWithResponseStreamResponseHandler.Builder)InvokeModelWithResponseStreamResponseHandler.builder().subscriber(InvokeModelWithResponseStreamResponseHandler.Visitor.builder().onChunk(part -> {
            try {
                String chunkJson = part.bytes().asUtf8String();
                String text = parser.extractText(chunkJson);
                if (text != null && !text.isEmpty()) {
                    chunks.add(text);
                    if (chunkConsumer != null) {
                        chunkConsumer.accept(text);
                    }
                }
                if (parser.isFinalChunk(chunkJson)) {
                    Integer tokenCount;
                    String completionReason = parser.extractCompletionReason(chunkJson);
                    if (completionReason != null) {
                        metadata.setCompletionReason(completionReason);
                    }
                    if ((tokenCount = parser.extractTokenCount(chunkJson)) != null) {
                        metadata.setTokenCount(tokenCount);
                    }
                }
                chunkCount[0] = chunkCount[0] + 1;
            }
            catch (JsonProcessingException e) {
                LOG.warn("Error parsing streaming chunk: {}", (Object)e.getMessage(), (Object)e);
            }
        }).build()).onComplete(() -> {
            metadata.setChunkCount(chunkCount[0]);
            metadata.setChunks(chunks);
        })).build();
    }

    public static class StreamMetadata {
        private String fullText;
        private List<String> chunks;
        private String completionReason;
        private Integer tokenCount;
        private int chunkCount;

        public String getFullText() {
            return this.fullText;
        }

        public void setFullText(String fullText) {
            this.fullText = fullText;
        }

        public List<String> getChunks() {
            return this.chunks;
        }

        public void setChunks(List<String> chunks) {
            this.chunks = chunks;
        }

        public String getCompletionReason() {
            return this.completionReason;
        }

        public void setCompletionReason(String completionReason) {
            this.completionReason = completionReason;
        }

        public Integer getTokenCount() {
            return this.tokenCount;
        }

        public void setTokenCount(Integer tokenCount) {
            this.tokenCount = tokenCount;
        }

        public int getChunkCount() {
            return this.chunkCount;
        }

        public void setChunkCount(int chunkCount) {
            this.chunkCount = chunkCount;
        }
    }
}

