/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.runtime.client.impl;

import java.net.URI;
import org.apache.camel.component.aws2.bedrock.runtime.BedrockConfiguration;
import org.apache.camel.component.aws2.bedrock.runtime.client.BedrockRuntimeInternalClient;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClientBuilder;
import software.amazon.awssdk.utils.AttributeMap;

public class BedrockRuntimeClientIAMProfileOptimizedImpl
implements BedrockRuntimeInternalClient {
    private static final Logger LOG = LoggerFactory.getLogger(BedrockRuntimeClientIAMProfileOptimizedImpl.class);
    private BedrockConfiguration configuration;

    public BedrockRuntimeClientIAMProfileOptimizedImpl(BedrockConfiguration configuration) {
        LOG.trace("Creating an AWS Bedrock Runtime client for an ec2 instance with IAM temporary credentials (normal for ec2s).");
        this.configuration = configuration;
    }

    @Override
    public BedrockRuntimeClient getBedrockRuntimeClient() {
        BedrockRuntimeClient client = null;
        BedrockRuntimeClientBuilder clientBuilder = BedrockRuntimeClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        if (ObjectHelper.isNotEmpty((String)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(String.valueOf(this.configuration.getProxyProtocol()) + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            clientBuilder = (BedrockRuntimeClientBuilder)clientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder);
        }
        if (this.configuration.getProfileCredentialsName() != null) {
            clientBuilder = (BedrockRuntimeClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create((String)this.configuration.getProfileCredentialsName()));
        }
        if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
            clientBuilder = (BedrockRuntimeClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        if (this.configuration.isOverrideEndpoint()) {
            clientBuilder.endpointOverride(URI.create(this.configuration.getUriEndpointOverride()));
        }
        if (this.configuration.isTrustAllCertificates()) {
            if (httpClientBuilder == null) {
                httpClientBuilder = ApacheHttpClient.builder();
            }
            SdkHttpClient ahc = httpClientBuilder.buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)Boolean.TRUE).build());
            clientBuilder.httpClient(ahc);
            clientBuilder.httpClientBuilder(null);
        }
        client = (BedrockRuntimeClient)clientBuilder.build();
        return client;
    }

    @Override
    public BedrockRuntimeAsyncClient getBedrockRuntimeAsyncClient() {
        BedrockRuntimeAsyncClient client = null;
        BedrockRuntimeAsyncClientBuilder clientBuilder = BedrockRuntimeAsyncClient.builder();
        if (this.configuration.getProfileCredentialsName() != null) {
            clientBuilder = (BedrockRuntimeAsyncClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create((String)this.configuration.getProfileCredentialsName()));
        }
        if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
            clientBuilder = (BedrockRuntimeAsyncClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        if (this.configuration.isOverrideEndpoint()) {
            clientBuilder.endpointOverride(URI.create(this.configuration.getUriEndpointOverride()));
        }
        client = (BedrockRuntimeAsyncClient)clientBuilder.build();
        return client;
    }
}

