/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.bedrock.runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.bedrock.runtime.BedrockConfiguration;
import org.apache.camel.component.aws2.bedrock.runtime.BedrockEndpoint;
import org.apache.camel.component.aws2.bedrock.runtime.BedrockOperations;
import org.apache.camel.component.aws2.bedrock.runtime.stream.BedrockStreamHandler;
import org.apache.camel.component.aws2.bedrock.runtime.stream.ConverseStreamHandler;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseResponse;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InferenceConfiguration;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithResponseStreamRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ToolConfiguration;

public class BedrockProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(BedrockProducer.class);
    private transient String bedrockProducerToString;

    public BedrockProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case invokeTextModel: {
                this.invokeTextModel(this.getEndpoint().getBedrockRuntimeClient(), exchange);
                break;
            }
            case invokeImageModel: {
                this.invokeImageModel(this.getEndpoint().getBedrockRuntimeClient(), exchange);
                break;
            }
            case invokeEmbeddingsModel: {
                this.invokeEmbeddingsModel(this.getEndpoint().getBedrockRuntimeClient(), exchange);
                break;
            }
            case invokeTextModelStreaming: {
                this.invokeTextModelStreaming(this.getEndpoint().getBedrockRuntimeClient(), exchange);
                break;
            }
            case invokeImageModelStreaming: {
                this.invokeImageModelStreaming(this.getEndpoint().getBedrockRuntimeClient(), exchange);
                break;
            }
            case invokeEmbeddingsModelStreaming: {
                this.invokeEmbeddingsModelStreaming(this.getEndpoint().getBedrockRuntimeClient(), exchange);
                break;
            }
            case converse: {
                this.converse(this.getEndpoint().getBedrockRuntimeClient(), exchange);
                break;
            }
            case converseStream: {
                this.converseStream(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private BedrockOperations determineOperation(Exchange exchange) {
        BedrockOperations operation = (BedrockOperations)((Object)exchange.getMessage().getHeader("CamelAwsBedrockOperation", BedrockOperations.class));
        if (ObjectHelper.isEmpty((Object)((Object)operation))) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected BedrockConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.bedrockProducerToString == null) {
            this.bedrockProducerToString = "BedrockProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.bedrockProducerToString;
    }

    public BedrockEndpoint getEndpoint() {
        return (BedrockEndpoint)super.getEndpoint();
    }

    private void invokeTextModel(BedrockRuntimeClient bedrockRuntimeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getMessage().getMandatoryBody();
            if (payload instanceof InvokeModelRequest) {
                InvokeModelResponse result;
                try {
                    result = bedrockRuntimeClient.invokeModel((InvokeModelRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Invoke Model command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = BedrockProducer.getMessageForResponse(exchange);
                this.setResponseText(result, message);
            }
        } else {
            InvokeModelResponse result;
            InvokeModelRequest.Builder builder = InvokeModelRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockContentType"))) {
                throw new IllegalArgumentException("Model Content Type must be specified");
            }
            String contentType = (String)exchange.getIn().getHeader("CamelAwsBedrockContentType", String.class);
            builder.contentType(contentType);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockAcceptContentType"))) {
                throw new IllegalArgumentException("Model Accept Content Type must be specified");
            }
            String acceptContentType = (String)exchange.getIn().getHeader("CamelAwsBedrockAcceptContentType", String.class);
            builder.accept(acceptContentType);
            InvokeModelRequest request = (InvokeModelRequest)builder.body(SdkBytes.fromUtf8String((String)String.valueOf(exchange.getMessage().getBody()))).modelId(this.getConfiguration().getModelId()).build();
            try {
                result = bedrockRuntimeClient.invokeModel(request);
            }
            catch (AwsServiceException ase) {
                LOG.trace("Invoke Model command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = BedrockProducer.getMessageForResponse(exchange);
            this.setResponseText(result, message);
        }
    }

    private void invokeImageModel(BedrockRuntimeClient bedrockRuntimeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getMessage().getMandatoryBody();
            if (payload instanceof InvokeModelRequest) {
                InvokeModelResponse result;
                try {
                    result = bedrockRuntimeClient.invokeModel((InvokeModelRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Invoke Image Model command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = BedrockProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            InvokeModelResponse result;
            InvokeModelRequest.Builder builder = InvokeModelRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockContentType"))) {
                throw new IllegalArgumentException("Model Content Type must be specified");
            }
            String contentType = (String)exchange.getIn().getHeader("CamelAwsBedrockContentType", String.class);
            builder.contentType(contentType);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockAcceptContentType"))) {
                throw new IllegalArgumentException("Model Accept Content Type must be specified");
            }
            String acceptContentType = (String)exchange.getIn().getHeader("CamelAwsBedrockAcceptContentType", String.class);
            builder.accept(acceptContentType);
            InvokeModelRequest request = (InvokeModelRequest)builder.body(SdkBytes.fromUtf8String((String)String.valueOf(exchange.getMessage().getBody()))).modelId(this.getConfiguration().getModelId()).build();
            try {
                result = bedrockRuntimeClient.invokeModel(request);
            }
            catch (AwsServiceException ase) {
                LOG.trace("Invoke Model command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = BedrockProducer.getMessageForResponse(exchange);
            try {
                BedrockProducer.setBase64Image(result, message);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void invokeEmbeddingsModel(BedrockRuntimeClient bedrockRuntimeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getMessage().getMandatoryBody();
            if (payload instanceof InvokeModelRequest) {
                InvokeModelResponse result;
                try {
                    result = bedrockRuntimeClient.invokeModel((InvokeModelRequest)payload);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Invoke Image Model command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = BedrockProducer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            InvokeModelResponse result;
            InvokeModelRequest.Builder builder = InvokeModelRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockContentType"))) {
                throw new IllegalArgumentException("Model Content Type must be specified");
            }
            String contentType = (String)exchange.getIn().getHeader("CamelAwsBedrockContentType", String.class);
            builder.contentType(contentType);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockAcceptContentType"))) {
                throw new IllegalArgumentException("Model Accept Content Type must be specified");
            }
            String acceptContentType = (String)exchange.getIn().getHeader("CamelAwsBedrockAcceptContentType", String.class);
            builder.accept(acceptContentType);
            InvokeModelRequest request = (InvokeModelRequest)builder.body(SdkBytes.fromUtf8String((String)String.valueOf(exchange.getMessage().getBody()))).modelId(this.getConfiguration().getModelId()).build();
            try {
                result = bedrockRuntimeClient.invokeModel(request);
            }
            catch (AwsServiceException ase) {
                LOG.trace("Invoke Model command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = BedrockProducer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private static void setBase64Image(InvokeModelResponse result, Message message) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonString = mapper.readTree(result.body().asUtf8String());
        message.setBody((Object)jsonString.get("images"));
    }

    protected void setResponseText(InvokeModelResponse result, Message message) {
        String modelId;
        switch (modelId = this.getConfiguration().getModelId()) {
            case "amazon.titan-text-express-v1": 
            case "amazon.titan-text-lite-v1": 
            case "amazon.titan-text-premier-v1:0": 
            case "amazon.titan-embed-text-v2:0": {
                this.setTitanText(result, message);
                break;
            }
            case "ai21.j2-ultra-v1": 
            case "ai21.j2-mid-v1": 
            case "ai21.jamba-1-5-large-v1:0": 
            case "ai21.jamba-1-5-mini-v1:0": {
                try {
                    this.setAi21Text(result, message);
                    break;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            case "anthropic.claude-instant-v1": 
            case "anthropic.claude-v2": 
            case "anthropic.claude-v2:1": {
                try {
                    this.setAnthropicText(result, message);
                    break;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            case "anthropic.claude-3-sonnet-20240229-v1:0": 
            case "anthropic.claude-3-5-sonnet-20240620-v1:0": 
            case "anthropic.claude-3-5-sonnet-20241022-v2:0": 
            case "anthropic.claude-3-haiku-20240307-v1:0": 
            case "anthropic.claude-3-5-haiku-20241022-v1:0": 
            case "anthropic.claude-3-opus-20240229-v1:0": 
            case "anthropic.claude-3-7-sonnet-20250219-v1:0": 
            case "anthropic.claude-opus-4-20250514-v1:0": 
            case "anthropic.claude-sonnet-4-20250514-v1:0": {
                try {
                    this.setAnthropicV3Text(result, message);
                    break;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            case "mistral.mistral-7b-instruct-v0:2": 
            case "mistral.mixtral-8x7b-instruct-v0:1": 
            case "mistral.mistral-large-2402-v1:0": 
            case "mistral.mistral-large-2407-v1:0": 
            case "mistral.mistral-small-2402-v1:0": 
            case "mistral.pixtral-large-2502-v1:0": {
                try {
                    this.setMistralText(result, message);
                    break;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            case "amazon.nova-lite-v1:0": 
            case "amazon.nova-micro-v1:0": 
            case "amazon.nova-premier-v1:0": 
            case "amazon.nova-pro-v1:0": {
                try {
                    this.setAnthropicV3Text(result, message);
                    break;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            case "cohere.command-r-plus-v1:0": 
            case "cohere.command-r-v1:0": {
                try {
                    this.setCohereText(result, message);
                    break;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            case "meta.llama3-8b-instruct-v1:0": 
            case "meta.llama3-70b-instruct-v1:0": 
            case "meta.llama3-1-8b-instruct-v1:0": 
            case "meta.llama3-1-70b-instruct-v1:0": 
            case "meta.llama3-1-405b-instruct-v1:0": 
            case "meta.llama3-2-1b-instruct-v1:0": 
            case "meta.llama3-2-3b-instruct-v1:0": 
            case "meta.llama3-2-11b-instruct-v1:0": 
            case "meta.llama3-2-90b-instruct-v1:0": 
            case "meta.llama3-3-70b-instruct-v1:0": 
            case "meta.llama4-maverick-17b-instruct-v1:0": 
            case "meta.llama4-scout-17b-instruct-v1:0": {
                try {
                    this.setLlamaText(result, message);
                    break;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new IllegalStateException("Unexpected model: " + modelId);
            }
        }
    }

    private void setTitanText(InvokeModelResponse result, Message message) {
        message.setBody((Object)result.body().asUtf8String());
    }

    private void setAi21Text(InvokeModelResponse result, Message message) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonString = mapper.readTree(result.body().asUtf8String());
        message.setBody((Object)jsonString.get("completions"));
    }

    private void setAnthropicText(InvokeModelResponse result, Message message) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonString = mapper.readTree(result.body().asUtf8String());
        message.setBody((Object)jsonString.get("completion"));
    }

    private void setAnthropicV3Text(InvokeModelResponse result, Message message) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonString = mapper.readTree(result.body().asUtf8String());
        message.setBody((Object)jsonString);
    }

    private void setMistralText(InvokeModelResponse result, Message message) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonString = mapper.readTree(result.body().asUtf8String());
        message.setBody((Object)jsonString);
    }

    private void setCohereText(InvokeModelResponse result, Message message) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonString = mapper.readTree(result.body().asUtf8String());
        message.setBody((Object)jsonString.get("text"));
    }

    private void setLlamaText(InvokeModelResponse result, Message message) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonString = mapper.readTree(result.body().asUtf8String());
        message.setBody((Object)jsonString.get("generation"));
    }

    private void invokeTextModelStreaming(BedrockRuntimeClient bedrockRuntimeClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getMessage().getMandatoryBody();
            if (payload instanceof InvokeModelWithResponseStreamRequest) {
                this.processStreamingRequest((InvokeModelWithResponseStreamRequest)payload, exchange);
            }
        } else {
            InvokeModelWithResponseStreamRequest.Builder builder = InvokeModelWithResponseStreamRequest.builder();
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockContentType"))) {
                throw new IllegalArgumentException("Model Content Type must be specified");
            }
            String contentType = (String)exchange.getIn().getHeader("CamelAwsBedrockContentType", String.class);
            builder.contentType(contentType);
            if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockAcceptContentType"))) {
                throw new IllegalArgumentException("Model Accept Content Type must be specified");
            }
            String acceptContentType = (String)exchange.getIn().getHeader("CamelAwsBedrockAcceptContentType", String.class);
            builder.accept(acceptContentType);
            InvokeModelWithResponseStreamRequest request = (InvokeModelWithResponseStreamRequest)builder.body(SdkBytes.fromUtf8String((String)String.valueOf(exchange.getMessage().getBody()))).modelId(this.getConfiguration().getModelId()).build();
            this.processStreamingRequest(request, exchange);
        }
    }

    private void invokeImageModelStreaming(BedrockRuntimeClient bedrockRuntimeClient, Exchange exchange) throws InvalidPayloadException {
        this.invokeTextModelStreaming(bedrockRuntimeClient, exchange);
    }

    private void invokeEmbeddingsModelStreaming(BedrockRuntimeClient bedrockRuntimeClient, Exchange exchange) throws InvalidPayloadException {
        this.invokeTextModelStreaming(bedrockRuntimeClient, exchange);
    }

    private void processStreamingRequest(InvokeModelWithResponseStreamRequest request, Exchange exchange) {
        try {
            String streamOutputMode = this.getConfiguration().getStreamOutputMode();
            if (streamOutputMode == null) {
                streamOutputMode = "complete";
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockStreamOutputMode"))) {
                streamOutputMode = (String)exchange.getIn().getHeader("CamelAwsBedrockStreamOutputMode", String.class);
            }
            Message message = BedrockProducer.getMessageForResponse(exchange);
            BedrockStreamHandler.StreamMetadata metadata = new BedrockStreamHandler.StreamMetadata();
            if ("chunks".equals(streamOutputMode)) {
                ArrayList<String> allChunks = new ArrayList<String>();
                this.getEndpoint().getBedrockRuntimeAsyncClient().invokeModelWithResponseStream(request, BedrockStreamHandler.createChunksHandler(this.getConfiguration().getModelId(), metadata, allChunks, null)).join();
                message.setBody(allChunks);
                if (this.getConfiguration().isIncludeStreamingMetadata()) {
                    this.setStreamingMetadata(message, metadata);
                }
            } else {
                StringBuilder fullText = new StringBuilder();
                this.getEndpoint().getBedrockRuntimeAsyncClient().invokeModelWithResponseStream(request, BedrockStreamHandler.createCompleteHandler(this.getConfiguration().getModelId(), metadata, fullText)).join();
                message.setBody((Object)fullText.toString());
                if (this.getConfiguration().isIncludeStreamingMetadata()) {
                    this.setStreamingMetadata(message, metadata);
                }
            }
        }
        catch (AwsServiceException ase) {
            LOG.trace("Invoke Model Streaming command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
    }

    private void setStreamingMetadata(Message message, BedrockStreamHandler.StreamMetadata metadata) {
        if (metadata.getCompletionReason() != null) {
            message.setHeader("CamelAwsBedrockCompletionReason", (Object)metadata.getCompletionReason());
        }
        if (metadata.getTokenCount() != null) {
            message.setHeader("CamelAwsBedrockTokenCount", (Object)metadata.getTokenCount());
        }
        message.setHeader("CamelAwsBedrockChunkCount", (Object)metadata.getChunkCount());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void converse(BedrockRuntimeClient bedrockRuntimeClient, Exchange exchange) throws InvalidPayloadException {
        ConverseRequest request;
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getMessage().getMandatoryBody();
            if (!(payload instanceof ConverseRequest)) throw new IllegalArgumentException("Converse operation requires ConverseRequest in POJO mode");
            request = (ConverseRequest)payload;
        } else {
            Document additionalFields;
            ToolConfiguration toolConfig;
            InferenceConfiguration inferenceConfig;
            ConverseRequest.Builder builder = ConverseRequest.builder();
            builder.modelId(this.getConfiguration().getModelId());
            List messages = (List)exchange.getMessage().getHeader("CamelAwsBedrockConverseMessages", List.class);
            if (messages == null) {
                throw new IllegalArgumentException("Converse operation requires messages in header CamelAwsBedrockConverseMessages");
            }
            builder.messages((Collection)messages);
            List system = (List)exchange.getMessage().getHeader("CamelAwsBedrockConverseSystem", List.class);
            if (system != null) {
                builder.system((Collection)system);
            }
            if ((inferenceConfig = (InferenceConfiguration)exchange.getMessage().getHeader("CamelAwsBedrockConverseInferenceConfig", InferenceConfiguration.class)) != null) {
                builder.inferenceConfig(inferenceConfig);
            }
            if ((toolConfig = (ToolConfiguration)exchange.getMessage().getHeader("CamelAwsBedrockConverseToolConfig", ToolConfiguration.class)) != null) {
                builder.toolConfig(toolConfig);
            }
            if ((additionalFields = (Document)exchange.getMessage().getHeader("CamelAwsBedrockConverseAdditionalFields", Document.class)) != null) {
                builder.additionalModelRequestFields(additionalFields);
            }
            request = (ConverseRequest)builder.build();
        }
        try {
            ConverseResponse response = bedrockRuntimeClient.converse(request);
            Message message = BedrockProducer.getMessageForResponse(exchange);
            if (response.output() != null && response.output().message() != null) {
                software.amazon.awssdk.services.bedrockruntime.model.Message outputMessage = response.output().message();
                message.setHeader("CamelAwsBedrockConverseOutputMessage", (Object)outputMessage);
                StringBuilder textContent = new StringBuilder();
                for (ContentBlock content : outputMessage.content()) {
                    if (content.text() == null) continue;
                    textContent.append(content.text());
                }
                message.setBody((Object)textContent.toString());
            }
            if (response.stopReason() != null) {
                message.setHeader("CamelAwsBedrockConverseStopReason", (Object)response.stopReason().toString());
            }
            if (response.usage() == null) return;
            message.setHeader("CamelAwsBedrockConverseUsage", (Object)response.usage());
            return;
        }
        catch (AwsServiceException ase) {
            LOG.trace("Converse command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void converseStream(Exchange exchange) throws InvalidPayloadException {
        ConverseStreamRequest request;
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getMessage().getMandatoryBody();
            if (!(payload instanceof ConverseStreamRequest)) throw new IllegalArgumentException("ConverseStream operation requires ConverseStreamRequest in POJO mode");
            request = (ConverseStreamRequest)payload;
        } else {
            Document additionalFields;
            ToolConfiguration toolConfig;
            InferenceConfiguration inferenceConfig;
            ConverseStreamRequest.Builder builder = ConverseStreamRequest.builder();
            builder.modelId(this.getConfiguration().getModelId());
            List messages = (List)exchange.getMessage().getHeader("CamelAwsBedrockConverseMessages", List.class);
            if (messages == null) {
                throw new IllegalArgumentException("ConverseStream operation requires messages in header CamelAwsBedrockConverseMessages");
            }
            builder.messages((Collection)messages);
            List system = (List)exchange.getMessage().getHeader("CamelAwsBedrockConverseSystem", List.class);
            if (system != null) {
                builder.system((Collection)system);
            }
            if ((inferenceConfig = (InferenceConfiguration)exchange.getMessage().getHeader("CamelAwsBedrockConverseInferenceConfig", InferenceConfiguration.class)) != null) {
                builder.inferenceConfig(inferenceConfig);
            }
            if ((toolConfig = (ToolConfiguration)exchange.getMessage().getHeader("CamelAwsBedrockConverseToolConfig", ToolConfiguration.class)) != null) {
                builder.toolConfig(toolConfig);
            }
            if ((additionalFields = (Document)exchange.getMessage().getHeader("CamelAwsBedrockConverseAdditionalFields", Document.class)) != null) {
                builder.additionalModelRequestFields(additionalFields);
            }
            request = (ConverseStreamRequest)builder.build();
        }
        this.processConverseStreamingRequest(request, exchange);
    }

    private void processConverseStreamingRequest(ConverseStreamRequest request, Exchange exchange) {
        try {
            String streamOutputMode = this.getConfiguration().getStreamOutputMode();
            if (streamOutputMode == null) {
                streamOutputMode = "complete";
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelAwsBedrockStreamOutputMode"))) {
                streamOutputMode = (String)exchange.getIn().getHeader("CamelAwsBedrockStreamOutputMode", String.class);
            }
            Message message = BedrockProducer.getMessageForResponse(exchange);
            ConverseStreamHandler.StreamMetadata metadata = new ConverseStreamHandler.StreamMetadata();
            if ("chunks".equals(streamOutputMode)) {
                ArrayList<String> allChunks = new ArrayList<String>();
                this.getEndpoint().getBedrockRuntimeAsyncClient().converseStream(request, ConverseStreamHandler.createChunksHandler(metadata, allChunks, null)).join();
                message.setBody(allChunks);
                if (this.getConfiguration().isIncludeStreamingMetadata()) {
                    this.setConverseStreamingMetadata(message, metadata);
                }
            } else {
                StringBuilder fullText = new StringBuilder();
                this.getEndpoint().getBedrockRuntimeAsyncClient().converseStream(request, ConverseStreamHandler.createCompleteHandler(metadata, fullText)).join();
                message.setBody((Object)fullText.toString());
                if (this.getConfiguration().isIncludeStreamingMetadata()) {
                    this.setConverseStreamingMetadata(message, metadata);
                }
            }
        }
        catch (AwsServiceException ase) {
            LOG.trace("Converse Stream command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
            throw ase;
        }
    }

    private void setConverseStreamingMetadata(Message message, ConverseStreamHandler.StreamMetadata metadata) {
        if (metadata.getStopReason() != null) {
            message.setHeader("CamelAwsBedrockConverseStopReason", (Object)metadata.getStopReason());
        }
        if (metadata.getUsage() != null) {
            message.setHeader("CamelAwsBedrockConverseUsage", (Object)metadata.getUsage());
        }
        message.setHeader("CamelAwsBedrockChunkCount", (Object)metadata.getChunkCount());
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

