/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.attachment;

import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.attachment.AttachmentExpressionBuilder;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.spi.SimpleLanguageFunctionFactory;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OgnlHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.StringQuoteHelper;

@JdkService(value="simple-function-factory/camel-attachments")
public class SimpleAttachmentFunction
implements SimpleLanguageFunctionFactory {
    public Expression createFunction(CamelContext camelContext, String function, int index) {
        if ("attachments".equals(function)) {
            return AttachmentExpressionBuilder.attachments();
        }
        if ("attachments.size".equals(function) || "attachments.size()".equals(function) || "attachments.length".equals(function) || "attachments.length()".equals(function)) {
            return AttachmentExpressionBuilder.attachmentsSize();
        }
        String remainder = this.ifStartsWithReturnRemainder("attachmentContent(", function);
        if (remainder != null) {
            String values = StringHelper.before((String)remainder, (String)")");
            if (values == null || ObjectHelper.isEmpty((String)values)) {
                throw new SimpleParserException("Valid syntax: ${attachmentContent(key)} was: " + function, index);
            }
            return AttachmentExpressionBuilder.attachmentContent(values, null);
        }
        remainder = this.ifStartsWithReturnRemainder("attachmentContentAs(", function);
        if (remainder != null) {
            String values = StringHelper.before((String)remainder, (String)")");
            if (values == null || ObjectHelper.isEmpty((String)values)) {
                throw new SimpleParserException("Valid syntax: ${attachmentContentAs(key,type)} was: " + function, index);
            }
            String[] tokens = StringQuoteHelper.splitSafeQuote((String)values, (char)',', (boolean)false);
            if (tokens.length > 2) {
                throw new SimpleParserException("Valid syntax: ${attachmentContentAs(key,type)} was: " + function, index);
            }
            String key = tokens[0];
            String type = tokens[1];
            return AttachmentExpressionBuilder.attachmentContent(key, type);
        }
        remainder = this.ifStartsWithReturnRemainder("attachmentContentAsText(", function);
        if (remainder != null) {
            String values = StringHelper.before((String)remainder, (String)")");
            if (values == null || ObjectHelper.isEmpty((String)values)) {
                throw new SimpleParserException("Valid syntax: ${attachmentContentAsText(key)}} was: " + function, index);
            }
            return AttachmentExpressionBuilder.attachmentContent(values, "String");
        }
        remainder = this.ifStartsWithReturnRemainder("attachmentHeaderAs(", function);
        if (remainder != null) {
            String values = StringHelper.before((String)remainder, (String)")");
            if (values == null || ObjectHelper.isEmpty((String)values)) {
                throw new SimpleParserException("Valid syntax: ${attachmentHeaderAs(key,name,type)} was: " + function, index);
            }
            String[] tokens = StringQuoteHelper.splitSafeQuote((String)values, (char)',', (boolean)false);
            if (tokens.length != 3) {
                throw new SimpleParserException("Valid syntax: ${attachmentHeaderAs(key,name,type)} was: " + function, index);
            }
            String key = tokens[0];
            String name = tokens[1];
            String type = tokens[2];
            return AttachmentExpressionBuilder.attachmentContentHeader(key, name, type);
        }
        remainder = this.ifStartsWithReturnRemainder("attachmentHeader(", function);
        if (remainder != null) {
            String values = StringHelper.before((String)remainder, (String)")");
            if (values == null || ObjectHelper.isEmpty((String)values)) {
                throw new SimpleParserException("Valid syntax: ${attachmentHeader(key,name)} was: " + function, index);
            }
            String[] tokens = StringQuoteHelper.splitSafeQuote((String)values, (char)',', (boolean)false);
            if (tokens.length != 2) {
                throw new SimpleParserException("Valid syntax: ${attachmentHeader(key,name)} was: " + function, index);
            }
            String key = tokens[0];
            String name = tokens[1];
            return AttachmentExpressionBuilder.attachmentContentHeader(key, name, null);
        }
        remainder = this.ifStartsWithReturnRemainder("attachmentContentType(", function);
        if (remainder != null) {
            String key = StringHelper.before((String)remainder, (String)")");
            if (key == null || ObjectHelper.isEmpty((String)key)) {
                throw new SimpleParserException("Valid syntax: ${attachmentContentType(key)} was: " + function, index);
            }
            return AttachmentExpressionBuilder.attachmentContentType(key);
        }
        remainder = this.ifStartsWithReturnRemainder("attachment", function);
        if (remainder != null) {
            boolean invalid;
            if (remainder.startsWith(".") || remainder.startsWith(":") || remainder.startsWith("?")) {
                remainder = remainder.substring(1);
            }
            if (remainder.startsWith("[") && remainder.endsWith("]")) {
                remainder = remainder.substring(1, remainder.length() - 1);
            }
            if (invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder)) {
                throw new SimpleParserException("Valid syntax: ${attachment.OGNL} was: " + function, index);
            }
            if (OgnlHelper.isValidOgnlExpression((String)remainder)) {
                return AttachmentExpressionBuilder.attachmentOgnlExpression(remainder);
            }
            return AttachmentExpressionBuilder.attachmentExpression(remainder);
        }
        return null;
    }

    public String createCode(CamelContext camelContext, String function, int index) {
        if ("attachments".equals(function)) {
            return "attachments(exchange)";
        }
        if ("attachments.size".equals(function) || "attachments.size()".equals(function) || "attachments.length".equals(function) || "attachments.length()".equals(function)) {
            return "attachmentsSize(exchange)";
        }
        String remainder = this.ifStartsWithReturnRemainder("attachmentContent(", function);
        if (remainder != null) {
            String values = StringHelper.before((String)remainder, (String)")");
            if (values == null || ObjectHelper.isEmpty((String)values)) {
                throw new SimpleParserException("Valid syntax: ${attachmentContent(key)} was: " + function, index);
            }
            String key = StringHelper.removeQuotes((String)values);
            key = key.trim();
            return "attachmentContent(exchange, \"" + key + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("attachmentContentAs(", function);
        if (remainder != null) {
            String values = StringHelper.before((String)remainder, (String)")");
            if (values == null || ObjectHelper.isEmpty((String)values)) {
                throw new SimpleParserException("Valid syntax: ${attachmentContentAs(key,type)} was: " + function, index);
            }
            String[] tokens = StringQuoteHelper.splitSafeQuote((String)values, (char)',', (boolean)false);
            if (tokens.length > 2) {
                throw new SimpleParserException("Valid syntax: ${attachmentContentAs(key,type)} was: " + function, index);
            }
            String key = tokens[0];
            String type = tokens[1];
            key = StringHelper.removeQuotes((String)key);
            key = key.trim();
            type = SimpleAttachmentFunction.appendClass(type);
            type = type.replace('$', '.');
            type = type.trim();
            return "attachmentContentAs(exchange, \"" + key + "\", " + type + ")";
        }
        remainder = this.ifStartsWithReturnRemainder("attachmentContentAsText(", function);
        if (remainder != null) {
            String values = StringHelper.before((String)remainder, (String)")");
            if (values == null || ObjectHelper.isEmpty((String)values)) {
                throw new SimpleParserException("Valid syntax: ${attachmentContentAsText(key)}} was: " + function, index);
            }
            String key = StringHelper.removeQuotes((String)values);
            key = key.trim();
            return "attachmentContentAsText(exchange, \"" + key + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("attachmentContentType(", function);
        if (remainder != null) {
            String key = StringHelper.before((String)remainder, (String)")");
            if (key == null || ObjectHelper.isEmpty((String)key)) {
                throw new SimpleParserException("Valid syntax: ${attachmentContentType(key)} was: " + function, index);
            }
            key = StringHelper.removeQuotes((String)key);
            key = key.trim();
            return "attachmentContentType(exchange, \"" + key + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("attachmentHeader(", function);
        if (remainder != null) {
            String values = StringHelper.before((String)remainder, (String)")");
            if (values == null || ObjectHelper.isEmpty((String)values)) {
                throw new SimpleParserException("Valid syntax: ${attachmentHeader(key,name)} was: " + function, index);
            }
            String[] tokens = StringQuoteHelper.splitSafeQuote((String)values, (char)',', (boolean)false);
            if (tokens.length != 2) {
                throw new SimpleParserException("Valid syntax: ${attachmentHeader(key,name)} was: " + function, index);
            }
            String key = tokens[0];
            String name = tokens[1];
            key = StringHelper.removeQuotes((String)key);
            key = key.trim();
            name = StringHelper.removeQuotes((String)name);
            name = name.trim();
            return "attachmentHeader(exchange, \"" + key + "\", \"" + name + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("attachmentHeaderAs(", function);
        if (remainder != null) {
            String values = StringHelper.before((String)remainder, (String)")");
            if (values == null || ObjectHelper.isEmpty((String)values)) {
                throw new SimpleParserException("Valid syntax: ${attachmentHeaderAs(key,name,type)} was: " + function, index);
            }
            String[] tokens = StringQuoteHelper.splitSafeQuote((String)values, (char)',', (boolean)false);
            if (tokens.length != 3) {
                throw new SimpleParserException("Valid syntax: ${attachmentHeaderAs(key,name,type)} was: " + function, index);
            }
            String key = tokens[0];
            String name = tokens[1];
            String type = tokens[2];
            key = StringHelper.removeQuotes((String)key);
            key = key.trim();
            name = StringHelper.removeQuotes((String)name);
            name = name.trim();
            type = SimpleAttachmentFunction.appendClass(type);
            type = type.replace('$', '.');
            type = type.trim();
            return "attachmentHeaderAs(exchange, \"" + key + "\", \"" + name + "\", " + type + ")";
        }
        return null;
    }

    private String ifStartsWithReturnRemainder(String prefix, String text) {
        String remainder;
        if (text.startsWith(prefix) && !(remainder = text.substring(prefix.length())).isEmpty()) {
            return remainder;
        }
        return null;
    }

    private static String appendClass(String type) {
        if (!((String)(type = StringHelper.removeQuotes((String)type))).endsWith(".class")) {
            type = (String)type + ".class";
        }
        return type;
    }
}

