/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atom;

import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.atom.AtomConstants;
import org.apache.camel.component.atom.AtomEntryPollingConsumer;
import org.apache.camel.component.atom.AtomPollingConsumer;
import org.apache.camel.component.feed.FeedComponent;
import org.apache.camel.component.feed.FeedEndpoint;
import org.apache.camel.component.feed.FeedPollingConsumer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;

@UriEndpoint(firstVersion="1.2.0", scheme="atom", title="Atom", syntax="atom:feedUri", consumerOnly=true, category={Category.DOCUMENT}, lenientProperties=true, headersClass=AtomConstants.class)
public class AtomEndpoint
extends FeedEndpoint
implements EndpointServiceLocation {
    public AtomEndpoint() {
    }

    public AtomEndpoint(String endpointUri, FeedComponent component, String feedUri) {
        super(endpointUri, component, feedUri);
    }

    public String getServiceUrl() {
        return this.feedUri;
    }

    public String getServiceProtocol() {
        return "atom";
    }

    @Override
    public Exchange createExchange(Object feed) {
        Exchange exchange = this.createExchangeWithFeedHeader(feed, "CamelAtomFeed");
        exchange.getIn().setBody(feed);
        return exchange;
    }

    @Override
    public Exchange createExchange(Object feed, Object entry) {
        Exchange exchange = this.createExchangeWithFeedHeader(feed, "CamelAtomFeed");
        exchange.getIn().setBody(entry);
        return exchange;
    }

    @Override
    protected FeedPollingConsumer createEntryPollingConsumer(FeedEndpoint feedEndpoint, Processor processor, boolean throttleEntries) throws Exception {
        AtomEntryPollingConsumer answer = new AtomEntryPollingConsumer(this, processor, throttleEntries);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    @Override
    protected FeedPollingConsumer createPollingConsumer(FeedEndpoint feedEndpoint, Processor processor) throws Exception {
        AtomPollingConsumer answer = new AtomPollingConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }
}

