/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.HeaderGroup;

public abstract class MimeEntity
extends AbstractHttpEntity {
    protected static final long UNKNOWN_CONTENT_LENGTH = -1L;
    protected static final long RECALCULATE_CONTENT_LENGTH = -2L;
    protected boolean isMainBody;
    protected long contentLength = -2L;
    private final HeaderGroup headergroup = new HeaderGroup();

    protected MimeEntity(ContentType contentType, String contentTransferEncoding) {
        super(contentType, contentTransferEncoding);
        if (contentType != null) {
            this.headergroup.addHeader((Header)new BasicHeader("Content-Type", (Object)contentType));
        }
        if (contentTransferEncoding != null) {
            BasicHeader encoding = new BasicHeader("Content-Transfer-Encoding", (Object)contentTransferEncoding);
            this.headergroup.addHeader((Header)encoding);
        }
    }

    public boolean isMainBody() {
        return this.isMainBody;
    }

    public void setMainBody(boolean isMainBody) {
        this.isMainBody = isMainBody;
    }

    public String getContentTransferEncodingValue() {
        Header contentTransferEncodingHeader = this.getContentTransferEncoding();
        if (contentTransferEncodingHeader != null) {
            return contentTransferEncodingHeader.getValue();
        }
        return null;
    }

    public Header getContentTransferEncoding() {
        return super.getContentEncoding() == null ? null : new BasicHeader("Content-Transfer-Encoding", (Object)super.getContentEncoding());
    }

    public boolean containsHeader(String name) {
        return this.headergroup.containsHeader(name);
    }

    public Header[] getHeaders(String name) {
        return this.headergroup.getHeaders(name);
    }

    public Header getFirstHeader(String name) {
        return this.headergroup.getFirstHeader(name);
    }

    public Header getLastHeader(String name) {
        return this.headergroup.getLastHeader(name);
    }

    public Header[] getAllHeaders() {
        return this.headergroup.getHeaders();
    }

    public void addHeader(Header header) {
        this.headergroup.addHeader(header);
    }

    public void addHeader(String name, String value) {
        ObjectHelper.notNull((Object)name, (String)"Header name");
        this.headergroup.addHeader((Header)new BasicHeader(name, (Object)value));
    }

    public void setHeader(Header header) {
        this.headergroup.setHeader(header);
    }

    public void setHeader(String name, String value) {
        ObjectHelper.notNull((Object)name, (String)"Header name");
        this.headergroup.setHeader((Header)new BasicHeader(name, (Object)value));
    }

    public void setHeaders(Header[] headers) {
        this.headergroup.setHeaders(headers);
    }

    public void removeHeader(Header header) {
        this.headergroup.removeHeader(header);
    }

    public void removeHeaders(String name) {
        if (name == null) {
            return;
        }
        this.headergroup.removeHeaders(name);
    }

    public void removeAllHeaders() {
        this.headergroup.clear();
    }

    public boolean isRepeatable() {
        return true;
    }

    public boolean isStreaming() {
        return !this.isRepeatable();
    }

    public long getContentLength() {
        if (this.contentLength == -2L) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                this.writeTo(out);
                this.contentLength = out.toByteArray().length;
            }
            catch (IOException e) {
                this.contentLength = -1L;
            }
        }
        return this.contentLength;
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        this.writeTo(outstream);
        outstream.flush();
        return new ByteArrayInputStream(outstream.toByteArray());
    }

    public String getCharset() {
        if (this.getContentType() == null) {
            return StandardCharsets.US_ASCII.name();
        }
        ContentType contentType = ContentType.parse((CharSequence)this.getContentType());
        Charset charset = contentType.getCharset();
        if (charset != null) {
            return charset.name();
        }
        return StandardCharsets.US_ASCII.name();
    }

    protected static class NoCloseOutputStream
    extends FilterOutputStream {
        public NoCloseOutputStream(OutputStream os) {
            super(os);
        }

        @Override
        public void close() {
        }
    }
}

