/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.camel.component.as2.api.AS2AsynchronousMDNManager;
import org.apache.camel.component.as2.api.AS2SignatureAlgorithm;
import org.apache.camel.component.as2.api.AS2SignedDataGenerator;
import org.apache.camel.component.as2.api.NotFoundHttpRequestHandler;
import org.apache.camel.component.as2.api.entity.DispositionNotificationMultipartReportEntity;
import org.apache.camel.component.as2.api.entity.MultipartSignedEntity;
import org.apache.camel.component.as2.api.io.AS2BHttpServerConnection;
import org.apache.camel.component.as2.api.protocol.ResponseMDN;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.io.HttpService;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.HttpServerConnection;
import org.apache.hc.core5.http.io.HttpServerRequestHandler;
import org.apache.hc.core5.http.io.support.BasicHttpServerRequestHandler;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import org.apache.hc.core5.http.protocol.RequestHandlerRegistry;
import org.apache.hc.core5.http.protocol.ResponseConnControl;
import org.apache.hc.core5.http.protocol.ResponseContent;
import org.apache.hc.core5.http.protocol.ResponseDate;
import org.apache.hc.core5.http.protocol.ResponseServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2ServerConnection {
    private static final Logger LOG = LoggerFactory.getLogger(AS2ServerConnection.class);
    private static final String REQUEST_LISTENER_THREAD_NAME_PREFIX = "AS2Svr-";
    private static final String REQUEST_HANDLER_THREAD_NAME_PREFIX = "AS2Hdlr-";
    public static final String AS2_DECRYPTING_PRIVATE_KEY = "AS2_DECRYPTING_PRIVATE_KEY";
    public static final String AS2_VALIDATE_SIGNING_CERTIFICATE_CHAIN = "AS2_VALIDATE_SIGNING_CERTIFICATE_CHAIN";
    public static final String AS2_SIGNING_PRIVATE_KEY = "AS2_SIGNING_PRIVATE_KEY";
    public static final String AS2_SIGNING_CERTIFICATE_CHAIN = "AS2_SIGNING_CERTIFICATE_CHAIN";
    public static final String AS2_SIGNING_ALGORITHM = "AS2_SIGNING_ALGORITHM";
    private ServerSocket serversocket;
    private RequestListenerService listenerService;
    private RequestAcceptorThread acceptorThread;
    private final Lock lock = new ReentrantLock();
    private final String as2Version;
    private final String originServer;
    private final String serverFqdn;
    private final Map<String, AS2ConsumerConfiguration> consumerConfigurations = new ConcurrentHashMap<String, AS2ConsumerConfiguration>();
    private static final ThreadLocal<ThreadLocalConfigWrapper> CURRENT_CONSUMER_CONFIG = new ThreadLocal();

    public Optional<AS2ConsumerConfiguration> getConfigurationForPath(String path) {
        return Optional.ofNullable(this.consumerConfigurations.get(path));
    }

    private AS2ConsumerConfiguration setupConfigurationForRequest(ClassicHttpRequest request, HttpContext context) {
        String requestUri = request.getRequestUri();
        String requestUriPath = this.cleanUpPath(requestUri);
        AS2ConsumerConfiguration config = this.getConfigurationForPath(requestUriPath).orElse(null);
        LOG.debug("Processing request. Incoming URI: {}, Canonical Path: {}. Config Found: {}", new Object[]{requestUri, requestUriPath, config != null});
        if (config == null) {
            LOG.warn("No AS2 consumer configuration found for canonical path: {}. Encrypted messages will likely fail.", (Object)requestUriPath);
            return null;
        }
        context.setAttribute(AS2_DECRYPTING_PRIVATE_KEY, (Object)config.getDecryptingPrivateKey());
        context.setAttribute(AS2_VALIDATE_SIGNING_CERTIFICATE_CHAIN, (Object)config.getValidateSigningCertificateChain());
        context.setAttribute(AS2_SIGNING_PRIVATE_KEY, (Object)config.getSigningPrivateKey());
        context.setAttribute(AS2_SIGNING_CERTIFICATE_CHAIN, (Object)config.getSigningCertificateChain());
        context.setAttribute(AS2_SIGNING_ALGORITHM, (Object)config.getSigningAlgorithm());
        Object checkKey = context.getAttribute(AS2_DECRYPTING_PRIVATE_KEY);
        if (checkKey == null) {
            LOG.error("FATAL: Decrypting Private Key failed to be read back from HttpContext immediately after injection for path: {}", (Object)requestUriPath);
        } else if (!(checkKey instanceof PrivateKey)) {
            LOG.error("FATAL: Key in HttpContext is not a PrivateKey object! Found type: {}", (Object)checkKey.getClass().getName());
        } else {
            LOG.debug("Context injection confirmed: Decrypting Key set successfully into HttpContext. Key type: {}", (Object)checkKey.getClass().getName());
        }
        ThreadLocalConfigWrapper wrapper = new ThreadLocalConfigWrapper(config, requestUriPath);
        CURRENT_CONSUMER_CONFIG.set(wrapper);
        return config;
    }

    private String cleanUpPath(String requestUri) {
        try {
            URI uri = new URI(requestUri);
            String path = uri.getPath();
            if (path == null || path.isEmpty()) {
                return "/";
            }
            return path;
        }
        catch (Exception e) {
            LOG.warn("Error parsing request URI: {}", (Object)requestUri, (Object)e);
            return "/";
        }
    }

    public AS2ServerConnection(String as2Version, String originServer, String serverFqdn, Integer serverPortNumber, AS2SignatureAlgorithm signingAlgorithm, Certificate[] signingCertificateChain, PrivateKey signingPrivateKey, PrivateKey decryptingPrivateKey, String mdnMessageTemplate, Certificate[] validateSigningCertificateChain, SSLContext sslContext) throws IOException {
        this.as2Version = (String)ObjectHelper.notNull((Object)as2Version, (String)"as2Version");
        this.originServer = (String)ObjectHelper.notNull((Object)originServer, (String)"userAgent");
        this.serverFqdn = (String)ObjectHelper.notNull((Object)serverFqdn, (String)"serverFqdn");
        Integer parserServerPortNumber = (Integer)ObjectHelper.notNull((Object)serverPortNumber, (String)"serverPortNumber");
        AS2ConsumerConfiguration consumerConfig = new AS2ConsumerConfiguration(signingAlgorithm, signingCertificateChain, signingPrivateKey, decryptingPrivateKey, validateSigningCertificateChain);
        this.registerConsumerConfiguration("/", consumerConfig);
        this.listenerService = new RequestListenerService(this.as2Version, this.originServer, this.serverFqdn, mdnMessageTemplate);
        this.acceptorThread = new RequestAcceptorThread(parserServerPortNumber, sslContext, this.listenerService);
        this.acceptorThread.setDaemon(true);
        this.acceptorThread.start();
    }

    public Certificate[] getValidateSigningCertificateChain() {
        return Optional.ofNullable(CURRENT_CONSUMER_CONFIG.get()).map(w -> w.config.getValidateSigningCertificateChain()).orElse(null);
    }

    public PrivateKey getSigningPrivateKey() {
        return Optional.ofNullable(CURRENT_CONSUMER_CONFIG.get()).map(w -> w.config.getSigningPrivateKey()).orElse(null);
    }

    public PrivateKey getDecryptingPrivateKey() {
        return Optional.ofNullable(CURRENT_CONSUMER_CONFIG.get()).map(w -> w.config.getDecryptingPrivateKey()).orElse(null);
    }

    public void registerConsumerConfiguration(String path, AS2ConsumerConfiguration config) {
        this.consumerConfigurations.put(path, config);
    }

    public void close() {
        if (this.acceptorThread != null) {
            this.lock.lock();
            try {
                try {
                    if (this.serversocket != null) {
                        this.serversocket.close();
                    }
                }
                catch (IOException e) {
                    LOG.debug(e.getMessage(), (Throwable)e);
                }
                finally {
                    this.acceptorThread = null;
                    this.listenerService = null;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void listen(String requestUri, HttpRequestHandler handler) {
        if (this.listenerService != null) {
            this.lock.lock();
            try {
                this.listenerService.registerHandler(requestUri, handler);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void unlisten(String requestUri) {
        if (this.listenerService != null) {
            this.lock.lock();
            try {
                this.listenerService.unregisterHandler(requestUri);
                this.consumerConfigurations.remove(requestUri);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected HttpProcessor initProtocolProcessor(String as2Version, String originServer, String serverFqdn, String mdnMessageTemplate) {
        return HttpProcessorBuilder.create().addFirst((HttpRequestInterceptor)new AS2ConsumerConfigInterceptor()).add((HttpResponseInterceptor)new ResponseContent(true)).add((HttpResponseInterceptor)new ResponseServer(originServer)).add((HttpResponseInterceptor)new ResponseDate()).add((HttpResponseInterceptor)new ResponseConnControl()).add((HttpResponseInterceptor)new ResponseMDN(as2Version, serverFqdn, mdnMessageTemplate)).build();
    }

    public static class AS2ConsumerConfiguration {
        private final Certificate[] signingCertificateChain;
        private final PrivateKey signingPrivateKey;
        private final PrivateKey decryptingPrivateKey;
        private final Certificate[] validateSigningCertificateChain;
        private final AS2SignatureAlgorithm signingAlgorithm;

        public AS2ConsumerConfiguration(AS2SignatureAlgorithm signingAlgorithm, Certificate[] signingCertificateChain, PrivateKey signingPrivateKey, PrivateKey decryptingPrivateKey, Certificate[] validateSigningCertificateChain) {
            this.signingAlgorithm = signingAlgorithm;
            this.signingCertificateChain = signingCertificateChain;
            this.signingPrivateKey = signingPrivateKey;
            this.decryptingPrivateKey = decryptingPrivateKey;
            this.validateSigningCertificateChain = validateSigningCertificateChain;
        }

        public Certificate[] getValidateSigningCertificateChain() {
            return this.validateSigningCertificateChain;
        }

        public Certificate[] getSigningCertificateChain() {
            return this.signingCertificateChain;
        }

        public AS2SignatureAlgorithm getSigningAlgorithm() {
            return this.signingAlgorithm;
        }

        public PrivateKey getSigningPrivateKey() {
            return this.signingPrivateKey;
        }

        public PrivateKey getDecryptingPrivateKey() {
            return this.decryptingPrivateKey;
        }
    }

    private static class ThreadLocalConfigWrapper {
        final AS2ConsumerConfiguration config;
        final String requestUriPath;

        ThreadLocalConfigWrapper(AS2ConsumerConfiguration config, String requestUriPath) {
            this.config = config;
            this.requestUriPath = requestUriPath;
        }
    }

    class RequestListenerService {
        private final HttpService httpService;
        private final RequestHandlerRegistry registry;

        public RequestListenerService(String as2Version, String originServer, String serverFqdn, String mdnMessageTemplate) throws IOException {
            HttpProcessor inhttpproc = AS2ServerConnection.this.initProtocolProcessor(as2Version, originServer, serverFqdn, mdnMessageTemplate);
            this.registry = new RequestHandlerRegistry();
            BasicHttpServerRequestHandler handler = new BasicHttpServerRequestHandler((HttpRequestMapper)this.registry);
            this.httpService = new HttpService(inhttpproc, (HttpServerRequestHandler)handler);
        }

        void registerHandler(String requestUriPattern, HttpRequestHandler httpRequestHandler) {
            this.registry.register(null, requestUriPattern, (Object)httpRequestHandler);
        }

        void unregisterHandler(String requestUriPattern) {
            this.registry.register(null, requestUriPattern, (Object)new NotFoundHttpRequestHandler());
        }
    }

    class RequestAcceptorThread
    extends Thread {
        private final RequestListenerService service;

        public RequestAcceptorThread(int port, SSLContext sslContext, RequestListenerService service) throws IOException {
            this.setName(AS2ServerConnection.REQUEST_LISTENER_THREAD_NAME_PREFIX + port);
            this.service = service;
            if (sslContext == null) {
                AS2ServerConnection.this.serversocket = new ServerSocket(port);
            } else {
                SSLServerSocketFactory factory = sslContext.getServerSocketFactory();
                AS2ServerConnection.this.serversocket = factory.createServerSocket(port);
            }
        }

        @Override
        public void run() {
            LOG.info("Listening on port {}", (Object)AS2ServerConnection.this.serversocket.getLocalPort());
            while (!Thread.interrupted()) {
                try {
                    Socket inSocket = AS2ServerConnection.this.serversocket.accept();
                    RequestHandlerThread t = new RequestHandlerThread(this.service.httpService, inSocket);
                    t.setDaemon(true);
                    t.start();
                }
                catch (InterruptedIOException | SocketException ex) {
                    break;
                }
                catch (IOException e) {
                    LOG.error("I/O error initialising connection thread: {}", (Object)e.getMessage());
                    break;
                }
            }
        }
    }

    private class AS2ConsumerConfigInterceptor
    implements HttpRequestInterceptor {
        private AS2ConsumerConfigInterceptor() {
        }

        public void process(HttpRequest request, EntityDetails entityDetails, HttpContext context) throws HttpException, IOException {
            if (request instanceof ClassicHttpRequest) {
                AS2ServerConnection.this.setupConfigurationForRequest((ClassicHttpRequest)request, context);
            }
        }
    }

    class RequestHandlerThread
    extends Thread {
        private final HttpService httpService;
        private final HttpServerConnection serverConnection;

        public RequestHandlerThread(HttpService httpService, Socket inSocket) throws IOException {
            int bufSize = 8192;
            Http1Config cfg = Http1Config.custom().setBufferSize(8192).build();
            AS2BHttpServerConnection inConn = new AS2BHttpServerConnection(cfg);
            LOG.info("Incoming connection from {}", (Object)inSocket.getInetAddress());
            inConn.bind(inSocket);
            this.setName(AS2ServerConnection.REQUEST_HANDLER_THREAD_NAME_PREFIX + this.getId());
            this.httpService = httpService;
            this.serverConnection = inConn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info("Processing new AS2 request");
            BasicHttpContext context = new BasicHttpContext(null);
            try {
                while (!Thread.interrupted()) {
                    this.httpService.handleRequest(this.serverConnection, (HttpContext)context);
                    HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)context);
                    AS2ConsumerConfiguration config = Optional.ofNullable(CURRENT_CONSUMER_CONFIG.get()).map(w -> w.config).orElse(null);
                    String recipientAddress = (String)coreContext.getAttribute("camel-as2.async-mdn.recipient-address", String.class);
                    if (recipientAddress == null || config == null) continue;
                    DispositionNotificationMultipartReportEntity multipartReportEntity = (DispositionNotificationMultipartReportEntity)((Object)coreContext.getAttribute("camel-as2.async-mdn.asynchronous-mdn", DispositionNotificationMultipartReportEntity.class));
                    AS2AsynchronousMDNManager asynchronousMDNManager = new AS2AsynchronousMDNManager(AS2ServerConnection.this.as2Version, AS2ServerConnection.this.originServer, AS2ServerConnection.this.serverFqdn, config.getSigningCertificateChain(), config.getSigningPrivateKey());
                    HttpRequest request = (HttpRequest)coreContext.getAttribute("http.request", HttpRequest.class);
                    AS2SignedDataGenerator gen = ResponseMDN.createSigningGenerator(request, config.getSigningAlgorithm(), config.getSigningCertificateChain(), config.getSigningPrivateKey());
                    if (gen != null) {
                        MultipartSignedEntity multipartSignedEntity = null;
                        try {
                            multipartSignedEntity = ResponseMDN.prepareSignedReceipt(gen, multipartReportEntity);
                        }
                        catch (Exception e) {
                            LOG.warn("failed to sign MDN");
                        }
                        if (multipartSignedEntity == null) continue;
                        asynchronousMDNManager.send(multipartSignedEntity, multipartSignedEntity.getContentType(), recipientAddress);
                        continue;
                    }
                    asynchronousMDNManager.send(multipartReportEntity, multipartReportEntity.getMainMessageContentType(), recipientAddress);
                }
            }
            catch (ConnectionClosedException ex) {
                LOG.info("Client closed connection");
            }
            catch (IOException ex) {
                LOG.error("I/O error: {}", (Object)ex.getMessage());
            }
            catch (HttpException ex) {
                LOG.error("Unrecoverable HTTP protocol violation: {}", (Object)ex.getMessage(), (Object)ex);
            }
            finally {
                try {
                    this.serverConnection.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

