/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.arangodb;

import com.arangodb.ArangoDB;
import com.arangodb.config.ProtocolConfig;
import com.arangodb.http.HttpProtocolConfig;
import io.vertx.core.Vertx;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.arangodb.ArangoDbComponent;
import org.apache.camel.component.arangodb.ArangoDbConfiguration;
import org.apache.camel.component.arangodb.ArangoDbConstants;
import org.apache.camel.component.arangodb.ArangoDbProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.5.0", scheme="arangodb", title="ArangoDb", syntax="arangodb:database", category={Category.DATABASE}, producerOnly=true, headersClass=ArangoDbConstants.class)
public class ArangoDbEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    @UriPath(description="database name")
    @Metadata(required=true)
    private String database;
    @UriParam
    private ArangoDbConfiguration configuration;
    @UriParam(label="advanced")
    private ArangoDB arangoDB;
    @UriParam(label="advanced")
    private Vertx vertx;

    public ArangoDbEndpoint() {
    }

    public ArangoDbEndpoint(String uri, ArangoDbComponent component, ArangoDbConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public String getServiceUrl() {
        return this.configuration.getHost() + ":" + this.configuration.getPort();
    }

    public String getServiceProtocol() {
        return "http";
    }

    public Map<String, String> getServiceMetadata() {
        if (this.configuration.getUser() != null) {
            return Map.of("username", this.configuration.getUser());
        }
        return null;
    }

    public Producer createProducer() {
        return new ArangoDbProducer(this);
    }

    public Consumer createConsumer(Processor processor) {
        throw new UnsupportedOperationException("You cannot receive messages at this endpoint: " + this.getEndpointUri());
    }

    public ArangoDB getArangoDB() {
        return this.arangoDB;
    }

    public void setArangoDB(ArangoDB arangoDB) {
        this.arangoDB = arangoDB;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public ArangoDbConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ArangoDbConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.arangoDB == null) {
            ArangoDB.Builder builder = new ArangoDB.Builder();
            if (ObjectHelper.isNotEmpty((String)this.configuration.getHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getPort())) {
                builder.host(this.configuration.getHost(), this.configuration.getPort());
            }
            if (ObjectHelper.isNotEmpty((String)this.configuration.getUser()) && ObjectHelper.isNotEmpty((String)this.configuration.getPassword())) {
                builder.user(this.configuration.getUser()).password(this.configuration.getPassword());
            }
            if (this.vertx != null) {
                builder.protocolConfig((ProtocolConfig)HttpProtocolConfig.builder().vertx(this.vertx).build());
            }
            this.arangoDB = builder.build();
        }
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.arangoDB != null) {
            this.arangoDB.shutdown();
        }
    }
}

