/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.health;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.health.HealthCheckResolver;
import org.apache.camel.util.ObjectHelper;

public final class HealthCheckHelper {
    private HealthCheckHelper() {
    }

    public static Collection<HealthCheck.Result> invoke(CamelContext camelContext) {
        return HealthCheckHelper.invoke(camelContext, (HealthCheck check) -> Map.of("check.kind", HealthCheck.Kind.ALL), (HealthCheck check) -> false);
    }

    public static Collection<HealthCheck.Result> invokeReadiness(CamelContext camelContext) {
        return HealthCheckHelper.invoke(camelContext, (HealthCheck check) -> Map.of("check.kind", HealthCheck.Kind.READINESS), (HealthCheck check) -> !check.isReadiness());
    }

    public static Collection<HealthCheck.Result> invokeLiveness(CamelContext camelContext) {
        return HealthCheckHelper.invoke(camelContext, (HealthCheck check) -> Map.of("check.kind", HealthCheck.Kind.LIVENESS), (HealthCheck check) -> !check.isLiveness());
    }

    public static Collection<HealthCheck.Result> invoke(CamelContext camelContext, Function<HealthCheck, Map<String, Object>> optionsSupplier) {
        return HealthCheckHelper.invoke(camelContext, optionsSupplier, (HealthCheck check) -> false);
    }

    public static Collection<HealthCheck.Result> invoke(CamelContext camelContext, Predicate<HealthCheck> filter) {
        return HealthCheckHelper.invoke(camelContext, (HealthCheck check) -> Collections.emptyMap(), filter);
    }

    public static Collection<HealthCheck.Result> invoke(CamelContext camelContext, Function<HealthCheck, Map<String, Object>> optionsSupplier, Predicate<HealthCheck> filter) {
        HealthCheckRegistry registry = HealthCheckRegistry.get(camelContext);
        if (registry != null) {
            Collection result = registry.stream().collect(Collectors.groupingBy(HealthCheckHelper::getGroup)).values().stream().flatMap(Collection::stream).filter(check -> !registry.isExcluded((HealthCheck)check) && !filter.test((HealthCheck)check)).sorted(Comparator.comparingInt(HealthCheck::getOrder)).distinct().map(check -> check.call((Map)optionsSupplier.apply((HealthCheck)check))).collect(Collectors.toList());
            if (result.isEmpty()) {
                return Collections.emptyList();
            }
            if ("full".equals(registry.getExposureLevel())) {
                return result;
            }
            Collection downs = result.stream().filter(r -> r.getState().equals((Object)HealthCheck.State.DOWN)).collect(Collectors.toCollection(ArrayList::new));
            if (!downs.isEmpty()) {
                if ("oneline".equals(registry.getExposureLevel())) {
                    return Collections.singleton((HealthCheck.Result)downs.iterator().next());
                }
                return downs;
            }
            HealthCheck.Result up = (HealthCheck.Result)result.iterator().next();
            return Collections.singleton(up);
        }
        return Collections.emptyList();
    }

    public static Optional<HealthCheck.Result> invoke(CamelContext camelContext, String id, Map<String, Object> options) {
        HealthCheckRegistry registry = HealthCheckRegistry.get(camelContext);
        if (registry != null) {
            return registry.getCheck(id).map(check -> check.call(options));
        }
        return Optional.empty();
    }

    public static HealthCheckRegistry getHealthCheckRegistry(CamelContext context) {
        return context.getExtension(HealthCheckRegistry.class);
    }

    public static HealthCheck getHealthCheck(CamelContext context, String id) {
        HealthCheck answer = null;
        HealthCheckRegistry hcr = context.getExtension(HealthCheckRegistry.class);
        if (hcr != null && hcr.isEnabled()) {
            HealthCheckResolver resolver;
            HealthCheck hc;
            Optional<HealthCheck> check = hcr.getCheck(id);
            if (check.isEmpty() && (hc = (resolver = context.adapt(ExtendedCamelContext.class).getHealthCheckResolver()).resolveHealthCheck(id)) != null) {
                check = Optional.of(hc);
                hcr.register(hc);
            }
            if (check.isPresent()) {
                answer = check.get();
            }
        }
        return answer;
    }

    public static <T extends HealthCheck> T getHealthCheck(CamelContext context, String id, Class<T> type) {
        HealthCheck answer = HealthCheckHelper.getHealthCheck(context, id);
        if (answer != null) {
            return (T)((HealthCheck)type.cast(answer));
        }
        return null;
    }

    public static HealthCheckRepository getHealthCheckRepository(CamelContext context, String id) {
        HealthCheckRepository answer = null;
        HealthCheckRegistry hcr = context.getExtension(HealthCheckRegistry.class);
        if (hcr != null && hcr.isEnabled()) {
            HealthCheckResolver resolver;
            HealthCheckRepository hr;
            Optional<HealthCheckRepository> repo = hcr.getRepository(id);
            if (repo.isEmpty() && (hr = (resolver = context.adapt(ExtendedCamelContext.class).getHealthCheckResolver()).resolveHealthCheckRepository(id)) != null) {
                repo = Optional.of(hr);
                hcr.register(hr);
            }
            if (repo.isPresent()) {
                answer = repo.get();
            }
        }
        return answer;
    }

    public static <T extends HealthCheckRepository> T getHealthCheckRepository(CamelContext context, String id, Class<T> type) {
        HealthCheckRepository answer = HealthCheckHelper.getHealthCheckRepository(context, id);
        if (answer != null) {
            return (T)((HealthCheckRepository)type.cast(answer));
        }
        return null;
    }

    public static boolean isResultsUp(Collection<HealthCheck.Result> results, boolean readiness) {
        boolean up = readiness ? results.stream().allMatch(r -> r.getState().equals((Object)HealthCheck.State.UP)) : results.stream().noneMatch(r -> r.getState().equals((Object)HealthCheck.State.DOWN));
        return up;
    }

    private static String getGroup(HealthCheck check) {
        return (String)ObjectHelper.supplyIfEmpty((Object)check.getGroup(), () -> "");
    }
}

