/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Date;
import java.util.Properties;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.camel.util.function.ThrowingHelper;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.codehaus.plexus.build.BuildContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGeneratorMojo
extends AbstractMojo {
    protected static final String PREFIX = "org.apache.camel.";
    protected static final String OUT_PACKAGE = "org.apache.camel.component.internal";
    protected static final String COMPONENT_PACKAGE = "org.apache.camel.component";
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Parameter(defaultValue="org.apache.camel.component.internal")
    protected String outPackage;
    @Parameter(required=true, property="org.apache.camel.scheme")
    protected String scheme;
    @Parameter(required=true, property="org.apache.camel.componentName")
    protected String componentName;
    @Parameter(required=true, defaultValue="org.apache.camel.component")
    protected String componentPackage;
    @Parameter(required=true, defaultValue="${project}", readonly=true)
    protected MavenProject project;
    private ClassLoader projectClassLoader;

    protected static VelocityEngine getEngine() throws MojoExecutionException {
        try {
            return VelocityEngineHolder.ENGINE;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public final void execute() throws MojoExecutionException {
        try {
            this.setProjectClassLoader(this.buildProjectClassLoader());
            this.executeInternal();
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            this.projectClassLoader = null;
        }
    }

    protected abstract void executeInternal() throws Exception;

    protected ClassLoader getProjectClassLoader() {
        return this.projectClassLoader;
    }

    protected void setProjectClassLoader(ClassLoader projectClassLoader) {
        this.projectClassLoader = projectClassLoader;
    }

    private ClassLoader buildProjectClassLoader() throws DependencyResolutionRequiredException, MalformedURLException {
        ClassLoader tccl;
        URL[] urls = (URL[])this.project.getTestClasspathElements().stream().map(File::new).map(ThrowingHelper.wrapAsFunction(e -> e.toURI().toURL())).peek(url -> this.log.debug("Adding project path {}", url)).toArray(URL[]::new);
        if (urls.length == 0) {
            urls = new URL[]{URI.create("file:src/main/java/").toURL(), URI.create("file:src/test/java/").toURL()};
        }
        return new URLClassLoader(urls, (tccl = Thread.currentThread().getContextClassLoader()) != null ? tccl : ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected void mergeTemplate(VelocityContext context, File outFile, String templateName) throws MojoExecutionException {
        Template template;
        File outDir = outFile.getParentFile();
        if (!outDir.isDirectory() && !outDir.mkdirs()) {
            throw new MojoExecutionException("Error creating directory " + String.valueOf(outDir));
        }
        context.put("generatedDate", (Object)new Date().toString());
        context.put("packageName", (Object)this.outPackage);
        context.put("newLine", (Object)"\n");
        try {
            template = AbstractGeneratorMojo.getEngine().getTemplate(templateName, "UTF-8");
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        try {
            StringWriter writer = new StringWriter();
            template.merge((Context)context, (Writer)writer);
            AbstractGeneratorMojo.updateResource(null, outFile.toPath(), writer.toString());
        }
        catch (VelocityException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public static String getCanonicalName(Class<?> type) {
        String canonicalName = type.getCanonicalName();
        int pkgEnd = canonicalName.lastIndexOf(46);
        if (pkgEnd > 0 && canonicalName.substring(0, pkgEnd).equals("java.lang")) {
            canonicalName = canonicalName.substring(pkgEnd + 1);
        }
        return canonicalName;
    }

    public static void updateResource(BuildContext buildContext, Path out, String data) {
        try {
            if (FileUtil.updateFile((Path)out, (String)data)) {
                AbstractGeneratorMojo.refresh(buildContext, out);
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static void refresh(BuildContext buildContext, Path file) {
        if (buildContext != null) {
            buildContext.refresh(file.toFile());
        }
    }

    private static class VelocityEngineHolder {
        private static final VelocityEngine ENGINE;

        private VelocityEngineHolder() {
        }

        static {
            Properties velocityProperties = new Properties();
            velocityProperties.setProperty("resource.loaders", "cloader");
            velocityProperties.setProperty("resource.loader.cloader.class", ClasspathResourceLoader.class.getName());
            Logger velocityLogger = LoggerFactory.getLogger((String)"org.apache.camel.maven.Velocity");
            velocityProperties.setProperty("runtime.log.name", velocityLogger.getName());
            ENGINE = new VelocityEngine(velocityProperties);
            ENGINE.init();
        }
    }
}

