/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.activemq;

import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.activemq.Service;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.activemq.ActiveMQConfiguration;
import org.apache.camel.component.activemq.OriginalDestinationPropagateStrategy;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.URISupport;
import org.springframework.jms.connection.SingleConnectionFactory;

@Component(value="activemq")
public class ActiveMQComponent
extends JmsComponent {
    private final CopyOnWriteArrayList<SingleConnectionFactory> singleConnectionFactoryList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Service> pooledConnectionFactoryServiceList = new CopyOnWriteArrayList();

    public ActiveMQComponent() {
    }

    public ActiveMQComponent(CamelContext context) {
        super(context);
    }

    public ActiveMQComponent(ActiveMQConfiguration configuration) {
        this.setConfiguration(configuration);
    }

    public static ActiveMQComponent activeMQComponent() {
        return new ActiveMQComponent();
    }

    public static ActiveMQComponent activeMQComponent(String brokerURL) {
        ActiveMQComponent answer = new ActiveMQComponent();
        if (answer.getConfiguration() instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)answer.getConfiguration()).setBrokerURL(brokerURL);
        }
        return answer;
    }

    public void setBrokerURL(String brokerURL) {
        if (this.getConfiguration() instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)this.getConfiguration()).setBrokerURL(brokerURL);
        }
    }

    public void setTrustAllPackages(boolean trustAllPackages) {
        if (this.getConfiguration() instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)this.getConfiguration()).setTrustAllPackages(trustAllPackages);
        }
    }

    public void setUsePooledConnection(boolean usePooledConnection) {
        if (this.getConfiguration() instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)this.getConfiguration()).setUsePooledConnection(usePooledConnection);
        }
    }

    public void setUseSingleConnection(boolean useSingleConnection) {
        if (this.getConfiguration() instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)this.getConfiguration()).setUseSingleConnection(useSingleConnection);
        }
    }

    protected void addPooledConnectionFactoryService(Service pooledConnectionFactoryService) {
        this.pooledConnectionFactoryServiceList.add(pooledConnectionFactoryService);
    }

    protected void addSingleConnectionFactory(SingleConnectionFactory singleConnectionFactory) {
        this.singleConnectionFactoryList.add(singleConnectionFactory);
    }

    protected String convertPathToActualDestination(String path, Map<String, Object> parameters) {
        String query;
        Map options = PropertiesHelper.extractProperties(parameters, (String)"destination.");
        try {
            query = URISupport.createQueryString((Map)options);
        }
        catch (URISyntaxException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        if (ObjectHelper.isNotEmpty((Object)query)) {
            return path + "?" + query;
        }
        return path;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getMessageCreatedStrategy() == null) {
            this.setMessageCreatedStrategy(new OriginalDestinationPropagateStrategy());
        }
    }

    protected void doStop() throws Exception {
        for (Service service : this.pooledConnectionFactoryServiceList) {
            try {
                service.stop();
            }
            catch (Throwable throwable) {}
        }
        this.pooledConnectionFactoryServiceList.clear();
        for (SingleConnectionFactory singleConnectionFactory : this.singleConnectionFactoryList) {
            try {
                singleConnectionFactory.destroy();
            }
            catch (Throwable throwable) {}
        }
        this.singleConnectionFactoryList.clear();
        super.doStop();
    }

    public void setConfiguration(JmsConfiguration configuration) {
        if (configuration instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)configuration).setActiveMQComponent(this);
        }
        super.setConfiguration(configuration);
    }

    protected JmsConfiguration createConfiguration() {
        ActiveMQConfiguration answer = new ActiveMQConfiguration();
        answer.setActiveMQComponent(this);
        return answer;
    }
}

