/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.bom.generator;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.maven.bom.generator.DependencyMatcher;
import org.apache.camel.maven.bom.generator.DependencySet;
import org.apache.camel.maven.bom.generator.ExternalBomConflictCheck;
import org.apache.camel.maven.bom.generator.ExternalBomConflictCheckSet;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Mojo(name="generate", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class BomGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${basedir}/pom.xml")
    protected File sourcePom;
    @Parameter(defaultValue="${project.build.directory}/${project.name}-pom.xml")
    protected File targetPom;
    @Parameter
    protected DependencySet dependencies;
    @Parameter
    protected ExternalBomConflictCheckSet checkConflicts;
    protected final ArtifactFactory artifactFactory;
    protected final ArtifactResolver artifactResolver;
    @Parameter(property="project.remoteArtifactRepositories", readonly=true, required=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter(property="localRepository", readonly=true, required=true)
    protected ArtifactRepository localRepository;

    @Inject
    public BomGeneratorMojo(ArtifactFactory artifactFactory, ArtifactResolver artifactResolver) {
        this.artifactFactory = artifactFactory;
        this.artifactResolver = artifactResolver;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            DependencyManagement mng = this.project.getDependencyManagement();
            List<Dependency> filteredDependencies = this.filter(mng.getDependencies());
            Set<String> externallyManagedDependencies = this.getExternallyManagedDependencies();
            this.checkConflictsWithExternalBoms(filteredDependencies, externallyManagedDependencies);
            Document pom = this.loadBasePom();
            this.overwriteDependencyManagement(pom, filteredDependencies);
            this.writePom(pom);
        }
        catch (MojoExecutionException | MojoFailureException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Cannot generate the output BOM file", ex);
        }
    }

    private List<Dependency> filter(List<Dependency> dependencyList) {
        ArrayList<Dependency> outDependencies = new ArrayList<Dependency>();
        DependencyMatcher inclusions = new DependencyMatcher(this.dependencies.getIncludes());
        DependencyMatcher exclusions = new DependencyMatcher(this.dependencies.getExcludes());
        for (Dependency dep : dependencyList) {
            boolean accept = inclusions.matches(dep) && !exclusions.matches(dep);
            this.getLog().debug((CharSequence)(String.valueOf(dep) + ((accept &= !"test-jar".equals(dep.getType())) ? " included in the BOM" : " excluded from BOM")));
            if (accept) {
                outDependencies.add(dep);
                continue;
            }
            if (!dep.getGroupId().startsWith("org.apache.camel")) continue;
            this.getLog().warn((CharSequence)(String.valueOf(dep) + " excluded from BOM"));
        }
        outDependencies.sort(Comparator.comparing(d -> d.getGroupId() + ":" + d.getArtifactId()));
        return outDependencies;
    }

    private Document loadBasePom() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document pom = builder.parse(this.sourcePom);
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression parentVersion = xpath.compile("/project/parent/version");
        this.setActualVersion(pom, parentVersion);
        XPathExpression projectVersion = xpath.compile("/project/version");
        this.setActualVersion(pom, projectVersion);
        return pom;
    }

    private void setActualVersion(Document pom, XPathExpression path) throws XPathExpressionException {
        Node node = (Node)path.evaluate(pom, XPathConstants.NODE);
        if (node != null && node.getTextContent() != null && node.getTextContent().trim().equals("${project.version}")) {
            node.setTextContent(this.project.getVersion());
        }
    }

    private void writePom(Document pom) throws Exception {
        String content;
        XPathExpression xpath = XPathFactory.newInstance().newXPath().compile("//text()[normalize-space(.) = '']");
        NodeList emptyNodes = (NodeList)xpath.evaluate(pom, XPathConstants.NODESET);
        for (int i = 0; i < emptyNodes.getLength(); ++i) {
            Node emptyNode = emptyNodes.item(i);
            emptyNode.getParentNode().removeChild(emptyNode);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        try {
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        catch (IllegalArgumentException emptyNode) {
            // empty catch block
        }
        try {
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        catch (IllegalArgumentException emptyNode) {
            // empty catch block
        }
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(pom);
        try (StringWriter out = new StringWriter();){
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
            content = out.toString();
        }
        content = content.replaceFirst("-->", "-->\n");
        FileUtil.updateFile((Path)this.targetPom.toPath(), (String)content);
    }

    private void overwriteDependencyManagement(Document pom, List<Dependency> dependencies) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile("/project/dependencyManagement/dependencies");
        NodeList nodes = (NodeList)expr.evaluate(pom, XPathConstants.NODESET);
        if (nodes.getLength() == 0) {
            throw new IllegalStateException("No dependencies found in the dependencyManagement section of the current pom");
        }
        Node dependenciesSection = nodes.item(0);
        while (dependenciesSection.hasChildNodes()) {
            Node child = dependenciesSection.getFirstChild();
            dependenciesSection.removeChild(child);
        }
        for (Dependency dep : dependencies) {
            Element dependencyEl = pom.createElement("dependency");
            Element groupIdEl = pom.createElement("groupId");
            groupIdEl.setTextContent(dep.getGroupId());
            dependencyEl.appendChild(groupIdEl);
            Element artifactIdEl = pom.createElement("artifactId");
            artifactIdEl.setTextContent(dep.getArtifactId());
            dependencyEl.appendChild(artifactIdEl);
            Element versionEl = pom.createElement("version");
            versionEl.setTextContent(dep.getVersion());
            dependencyEl.appendChild(versionEl);
            if (!"jar".equals(dep.getType())) {
                Element typeEl = pom.createElement("type");
                typeEl.setTextContent(dep.getType());
                dependencyEl.appendChild(typeEl);
            }
            if (dep.getClassifier() != null) {
                Element classifierEl = pom.createElement("classifier");
                classifierEl.setTextContent(dep.getClassifier());
                dependencyEl.appendChild(classifierEl);
            }
            if (dep.getScope() != null && !"compile".equals(dep.getScope())) {
                Element scopeEl = pom.createElement("scope");
                scopeEl.setTextContent(dep.getScope());
                dependencyEl.appendChild(scopeEl);
            }
            if (dep.getExclusions() != null && !dep.getExclusions().isEmpty()) {
                Element exclsEl = pom.createElement("exclusions");
                for (Exclusion e : dep.getExclusions()) {
                    Element exclEl = pom.createElement("exclusion");
                    Element groupIdExEl = pom.createElement("groupId");
                    groupIdExEl.setTextContent(e.getGroupId());
                    exclEl.appendChild(groupIdExEl);
                    Element artifactIdExEl = pom.createElement("artifactId");
                    artifactIdExEl.setTextContent(e.getArtifactId());
                    exclEl.appendChild(artifactIdExEl);
                    exclsEl.appendChild(exclEl);
                }
                dependencyEl.appendChild(exclsEl);
            }
            dependenciesSection.appendChild(dependencyEl);
        }
    }

    private void checkConflictsWithExternalBoms(Collection<Dependency> dependencies, Set<String> external) throws MojoFailureException {
        TreeSet<String> errors = new TreeSet<String>();
        for (Dependency d : dependencies) {
            String key = this.comparisonKey(d);
            if (!external.contains(key)) continue;
            errors.add(key);
        }
        if (!errors.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Found ").append(errors.size()).append(" conflicts between the current managed dependencies and the external BOMS:\n");
            for (String error : errors) {
                msg.append(" - ").append(error).append("\n");
            }
            throw new MojoFailureException(msg.toString());
        }
    }

    private Set<String> getExternallyManagedDependencies() throws Exception {
        HashSet<String> provided = new HashSet<String>();
        if (this.checkConflicts != null && this.checkConflicts.getBoms() != null) {
            for (ExternalBomConflictCheck check : this.checkConflicts.getBoms()) {
                Set<String> bomProvided = this.getProvidedDependencyManagement(check.getGroupId(), check.getArtifactId(), check.getVersion());
                provided.addAll(bomProvided);
            }
        }
        return provided;
    }

    private Set<String> getProvidedDependencyManagement(String groupId, String artifactId, String version) throws Exception {
        return this.getProvidedDependencyManagement(groupId, artifactId, version, new TreeSet<String>());
    }

    private Set<String> getProvidedDependencyManagement(String groupId, String artifactId, String version, Set<String> gaChecked) throws Exception {
        String ga = groupId + ":" + artifactId;
        gaChecked.add(ga);
        Artifact bom = this.resolveArtifact(groupId, artifactId, version, "pom");
        MavenProject bomProject = this.loadExternalProjectPom(bom.getFile());
        HashSet<String> provided = new HashSet<String>();
        if (bomProject.getDependencyManagement() != null && bomProject.getDependencyManagement().getDependencies() != null) {
            for (Dependency dep : bomProject.getDependencyManagement().getDependencies()) {
                if ("pom".equals(dep.getType()) && "import".equals(dep.getScope())) {
                    String subGa = dep.getGroupId() + ":" + dep.getArtifactId();
                    if (gaChecked.contains(subGa)) continue;
                    Set<String> sub = this.getProvidedDependencyManagement(dep.getGroupId(), dep.getArtifactId(), this.resolveVersion(bomProject, dep.getVersion()), gaChecked);
                    provided.addAll(sub);
                    continue;
                }
                provided.add(this.comparisonKey(dep));
            }
        }
        return provided;
    }

    private String resolveVersion(MavenProject project, String version) {
        if (((String)version).contains("${")) {
            int start = ((String)version).indexOf("${");
            int end = ((String)version).indexOf("}");
            if (end > start) {
                String prop = ((String)version).substring(start + 2, end);
                String resolved = project.getProperties().getProperty(prop);
                if (resolved != null) {
                    if (resolved.contains("${")) {
                        resolved = this.resolveVersion(project, resolved);
                    }
                    version = ((String)version).substring(0, start) + resolved + ((String)version).substring(end + 1);
                }
            }
        }
        return version;
    }

    private String comparisonKey(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + (dependency.getType() != null ? dependency.getType() : "jar");
    }

    private Artifact resolveArtifact(String groupId, String artifactId, String version, String type) throws Exception {
        Artifact art = this.artifactFactory.createArtifact(groupId, artifactId, version, "runtime", type);
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(this.remoteRepositories).setLocalRepository(this.localRepository);
        return this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, art).getArtifact();
    }

    private MavenProject loadExternalProjectPom(File pomFile) throws Exception {
        try (FileReader reader = new FileReader(pomFile);){
            MavenXpp3Reader mavenReader = new MavenXpp3Reader();
            Model model = mavenReader.read((Reader)reader);
            MavenProject project = new MavenProject(model);
            project.setFile(pomFile);
            MavenProject mavenProject = project;
            return mavenProject;
        }
    }
}

